/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.DatabaseContext;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class MethodEntityContextProvider<U extends IIdentifiable> {
    private final Optional<EntityContext<U>> entityContext;
    private final Optional<BulkEntityContext<U>> bulkEntityContext;
    private final Optional<DatabaseContext> databaseContext;

    public MethodEntityContextProvider(Method method, Object[] args) {
        ArrayList parameterTypes = Lists.newArrayList((Object[])method.getParameterTypes());
        int entityContextIndex = parameterTypes.indexOf(EntityContext.class);
        int bulkEntityContextIndex = parameterTypes.indexOf(BulkEntityContext.class);
        int databaseContextIndex = parameterTypes.indexOf(DatabaseContext.class);
        this.entityContext = entityContextIndex >= 0 ? Optional.of((Object)((EntityContext)args[entityContextIndex])) : Optional.absent();
        this.bulkEntityContext = bulkEntityContextIndex >= 0 ? Optional.of((Object)((BulkEntityContext)args[bulkEntityContextIndex])) : Optional.absent();
        this.databaseContext = databaseContextIndex >= 0 ? Optional.of((Object)((DatabaseContext)args[databaseContextIndex])) : Optional.absent();
    }

    public Optional<EntityContext<U>> getEntityContext() {
        return this.entityContext;
    }

    public Optional<BulkEntityContext<U>> getBulkEntityContext() {
        return this.bulkEntityContext;
    }

    public Optional<DatabaseContext> getDatabaseContext() {
        return this.databaseContext;
    }
}

