/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.Document;
import com.atlassian.rm.common.bridges.lucene.Document73;
import com.atlassian.rm.common.bridges.lucene.IndexReader;
import com.atlassian.rm.common.bridges.lucene.IndexReader73;
import com.atlassian.rm.common.bridges.lucene.IndexSearcher;
import com.atlassian.rm.common.bridges.lucene.IndexSearcher73;
import com.atlassian.rm.common.bridges.lucene.MultiIndexReader;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.ReaderUtil;

public class MultiIndexReader73
implements MultiIndexReader {
    private final MultiReader reader;

    public MultiIndexReader73(Collection<IndexReader> subReaders) throws IOException {
        this.reader = new MultiReader(Collections2.transform(subReaders, (Function)new Function<IndexReader, org.apache.lucene.index.IndexReader>(){

            public org.apache.lucene.index.IndexReader apply(IndexReader subReader) {
                return ((IndexReader73)subReader).getLuceneValue();
            }
        }).toArray(new org.apache.lucene.index.IndexReader[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiIndexReader73 that = (MultiIndexReader73)o;
        return this.reader.equals((Object)that.reader);
    }

    public int hashCode() {
        return this.reader.hashCode();
    }

    @Override
    public Document getDocument(int position) throws IOException {
        return new Document73(this.reader.document(position));
    }

    @Override
    public Document getDocument(int position, List<String> fieldNames) throws IOException {
        return new Document73(this.reader.document(position, (Set)Sets.newHashSet(fieldNames)));
    }

    @Override
    public IndexSearcher openSearcher() {
        return new IndexSearcher73(new org.apache.lucene.search.IndexSearcher((org.apache.lucene.index.IndexReader)this.reader));
    }

    @Override
    public void extractAllReaders(Collection<IndexReader> collection) {
        for (LeafReaderContext leafReaderContext : this.reader.leaves()) {
            collection.add(new IndexReader73((org.apache.lucene.index.IndexReader)leafReaderContext.reader()));
        }
    }

    @Override
    public IndexReader extractSubReaderForDoc(int doc) {
        return new IndexReader73((org.apache.lucene.index.IndexReader)((LeafReaderContext)this.reader.leaves().get(ReaderUtil.subIndex((int)doc, (List)this.reader.leaves()))).reader());
    }

    @Override
    public boolean isClosed() {
        return this.reader.getRefCount() <= 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

