/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.EpisodeStreamState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IEpisodeState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IEpisodeStreamState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.ITemporalDependencyState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisodeStream;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.ITimePlan;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class TimePlanState
implements ITemporalDependencyState {
    private final Map<String, IEpisodeStreamState> streamStateMap;
    private final Map<String, String> episodeIdToStreamIdMap;
    private final Map<String, String> itemIdToStreamIdMap;

    TimePlanState(Map<String, IEpisodeStreamState> streamStateMap, Map<String, String> itemIdToStreamIdMap, Map<String, String> episodeIdToStreamIdMap) {
        this.streamStateMap = streamStateMap;
        this.itemIdToStreamIdMap = itemIdToStreamIdMap;
        this.episodeIdToStreamIdMap = episodeIdToStreamIdMap;
    }

    @Override
    public void setFinishedItemWithId(String itemId, String episodeId, int end) {
        String streamId = this.itemIdToStreamIdMap.get(itemId);
        IEpisodeStreamState streamState = this.streamStateMap.get(streamId);
        streamState.setFinishedItemWithId(itemId, end, episodeId);
    }

    @Override
    public void setFailForItemIdEpisodeId(String itemId, String episodeId) {
        String streamId = this.itemIdToStreamIdMap.get(itemId);
        IEpisodeStreamState streamState = this.streamStateMap.get(streamId);
        streamState.setFailForItemIdEpisodeId(itemId, episodeId);
    }

    @Override
    public IEpisodeState getEpisodeState(String episodeId) {
        String streamId = this.episodeIdToStreamIdMap.get(episodeId);
        IEpisodeStreamState streamState = this.streamStateMap.get(streamId);
        return streamState.getEpisodeState(episodeId);
    }

    public static TimePlanState initialize(ITimePlan timePlan, Set<IProcessingItem> itemsSet) {
        HashMap itemIdToStreamIdMap = Maps.newHashMap();
        for (IProcessingItem item : itemsSet) {
            itemIdToStreamIdMap.put(item.getId(), item.getStreamId());
        }
        Map<String, IEpisodeStreamState> streamStates = TimePlanState.createStreamStates(timePlan, itemsSet);
        Map<String, String> episodeToStreamIdMap = TimePlanState.createEpisodeToStreamIdMap(timePlan);
        TimePlanState instance = new TimePlanState(streamStates, itemIdToStreamIdMap, episodeToStreamIdMap);
        return instance;
    }

    private static Map<String, String> createEpisodeToStreamIdMap(ITimePlan timePlan) {
        HashMap episodeToStreamIdMap = Maps.newHashMap();
        Set<IEpisodeStream> streams = timePlan.getEpisodeStreams();
        for (IEpisodeStream stream : streams) {
            String streamId = stream.getId();
            List<IEpisode> episodes = stream.getEpisodes();
            for (IEpisode episode : episodes) {
                episodeToStreamIdMap.put(episode.getId(), streamId);
            }
        }
        return episodeToStreamIdMap;
    }

    private static Map<String, IEpisodeStreamState> createStreamStates(ITimePlan timePlan, Set<IProcessingItem> itemsSet) {
        Map<String, Set<IProcessingItem>> streamToAssignedItems = TimePlanState.getStreamPartitioned(itemsSet);
        HashMap streamStates = Maps.newHashMap();
        Set<IEpisodeStream> episodeStreams = timePlan.getEpisodeStreams();
        for (IEpisodeStream episodeStream : episodeStreams) {
            String streamId = episodeStream.getId();
            HashSet assigned = streamToAssignedItems.get(streamId);
            if (assigned == null) {
                assigned = Sets.newHashSet();
            }
            IEpisodeStreamState state = EpisodeStreamState.initialize(episodeStream, assigned);
            streamStates.put(streamId, state);
        }
        return streamStates;
    }

    private static Map<String, Set<IProcessingItem>> getStreamPartitioned(Set<IProcessingItem> itemsSet) {
        HashMap streamPartitions = Maps.newHashMap();
        for (IProcessingItem item : itemsSet) {
            String streamId = item.getStreamId();
            RmUtils.addToKeyedSets(streamPartitions, streamId, item);
        }
        return streamPartitions;
    }
}

