/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.google.common.collect.ImmutableList;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.Template;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.TemplateFactory;
import com.mysema.query.types.Visitor;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TemplateExpressionImpl<T>
extends ExpressionBase<T>
implements TemplateExpression<T> {
    private static final long serialVersionUID = 6951623726800809083L;
    private final ImmutableList<?> args;
    private final Template template;

    public static <C> Expression<C> create(Class<C> cl, String template) {
        return new TemplateExpressionImpl<C>(cl, TemplateFactory.DEFAULT.create(template), ImmutableList.of());
    }

    public static <C> Expression<C> create(Class<C> cl, String template, Object one) {
        return new TemplateExpressionImpl<C>(cl, TemplateFactory.DEFAULT.create(template), ImmutableList.of((Object)one));
    }

    public static <C> Expression<C> create(Class<C> cl, String template, Object one, Object two) {
        return new TemplateExpressionImpl<C>(cl, TemplateFactory.DEFAULT.create(template), ImmutableList.of((Object)one, (Object)two));
    }

    public static <C> Expression<C> create(Class<C> cl, String template, Object ... args) {
        return new TemplateExpressionImpl<C>(cl, TemplateFactory.DEFAULT.create(template), args);
    }

    public static <C> Expression<C> create(Class<C> cl, Template template, Object ... args) {
        return new TemplateExpressionImpl<C>(cl, template, args);
    }

    protected TemplateExpressionImpl(Class<? extends T> type, Template template, Object ... args) {
        this(type, template, ImmutableList.copyOf((Object[])args));
    }

    public TemplateExpressionImpl(Class<? extends T> type, Template template, ImmutableList<?> args) {
        super(type);
        this.args = args;
        this.template = template;
    }

    @Override
    public final Object getArg(int index) {
        return this.getArgs().get(index);
    }

    @Override
    public final List<?> getArgs() {
        return this.args;
    }

    @Override
    public final Template getTemplate() {
        return this.template;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TemplateExpression) {
            TemplateExpression c = (TemplateExpression)o;
            return c.getTemplate().equals(this.template) && c.getType().equals(this.getType()) && c.getArgs().equals(this.args);
        }
        return false;
    }

    @Override
    public final <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }
}

