/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.people.ISprint;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.entities.themes.ITheme;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemType;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOIdentifiableImpl;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOSprint;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.themes.AOTheme;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import java.util.List;

public class AOWorkItemImpl
extends AOIdentifiableImpl<IWorkItem> {
    private static final Log LOGGER = Log.with(AOWorkItemImpl.class);
    private final AOWorkItem data;

    public AOWorkItemImpl(AOWorkItem data) {
        super(data);
        this.data = data;
    }

    public Optional<Long> getEarliestStart() {
        return Optional.fromNullable((Object)this.data.getAOEarliestStart());
    }

    public void setEarliestStart(Long date) {
        this.data.setAOEarliestStart(date);
    }

    public Optional<Long> getTargetStart() {
        return Optional.fromNullable((Object)this.data.getAOTargetStart());
    }

    public void setTargetStart(Long date) {
        this.data.setAOTargetStart(date);
    }

    public Optional<Long> getTargetEnd() {
        return Optional.fromNullable((Object)this.data.getAOTargetEnd());
    }

    public void setTargetEnd(Long date) {
        this.data.setAOTargetEnd(date);
    }

    public Optional<Double> getBusinessValue() {
        return Optional.fromNullable((Object)this.data.getAOBusinessValue());
    }

    public void setBusinessValue(Double businessValue) {
        this.data.setAOBusinessValue(businessValue);
    }

    public List<String> getPrerequisites() {
        throw new RuntimeException("This is not the method you're looking for. Move along. Do not access prerequisites directly on AO entities. Use custom queries or the SchedulingPlan wrapper instead.");
    }

    public IPlan getPlan() {
        return this.data.getAOPlan();
    }

    public void setPlan(IPlan plan) {
        this.setExplicitRelation(plan, AOPlan.class, new AOIdentifiableImpl.IRelationCallback<AOPlan>(){

            @Override
            public void apply(AOPlan relation) {
                String orderRangeId = WorkItems.OrderRangeIdentifiers.forType(AOWorkItemImpl.this.data.getType());
                AOWorkItemImpl.this.data.setOrderRangeIdentifier(orderRangeId + "-" + relation.getId());
                AOWorkItemImpl.this.data.setAOPlan(relation);
            }
        });
    }

    public List<IWorkItem> getChildren() {
        return Lists.newArrayList((Object[])this.data.getAOChildren());
    }

    public IWorkItem getParent() {
        return this.data.getAOParent();
    }

    public void setParent(IWorkItem parent) {
        this.setExplicitRelation(parent, AOWorkItem.class, new AOIdentifiableImpl.IRelationCallback<AOWorkItem>(){

            @Override
            public void apply(AOWorkItem relation) {
                AOWorkItemImpl.this.data.setAOParent(relation);
            }
        });
    }

    public String getParentId() {
        IWorkItem parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getId();
    }

    public List<IExtensionLink> getExtensionLinks() {
        return Lists.newArrayList((Object[])this.data.getAOExtensionLinks());
    }

    public List<IEstimate> getEstimates() {
        return Lists.newArrayList((Object[])this.data.getAOEstimates());
    }

    public void clearReplanning(ActiveObjectsUtilities activeObjectsUtilities) {
        this.data.setReplanningStatus(null);
    }

    public void setRelease(IRelease release) {
        this.setExplicitRelation(release, AORelease.class, new AOIdentifiableImpl.IRelationCallback<AORelease>(){

            @Override
            public void apply(AORelease relation) {
                AOWorkItemImpl.this.data.setAORelease(relation);
            }
        });
    }

    public Optional<IRelease> getRelease() {
        return Optional.fromNullable((Object)this.data.getAORelease());
    }

    public void setStream(IStream stream) {
        this.setExplicitRelation(stream, AOStream.class, new AOIdentifiableImpl.IRelationCallback<AOStream>(){

            @Override
            public void apply(AOStream relation) {
                AOWorkItemImpl.this.data.setAOStream(relation);
            }
        });
    }

    public Optional<IStream> getStream() {
        return Optional.fromNullable((Object)this.data.getAOStream());
    }

    public void setTheme(ITheme theme) {
        this.setExplicitRelation(theme, AOTheme.class, new AOIdentifiableImpl.IRelationCallback<AOTheme>(){

            @Override
            public void apply(AOTheme relation) {
                AOWorkItemImpl.this.data.setAOTheme(relation);
            }
        });
    }

    public Optional<String> getThemeId() {
        AOTheme aoTheme = this.data.getAOTheme();
        if (aoTheme == null) {
            return Optional.absent();
        }
        return Optional.of((Object)aoTheme.getId());
    }

    public Optional<ITheme> getTheme() {
        return Optional.fromNullable((Object)this.data.getAOTheme());
    }

    public void setTeam(ITeam team) {
        this.setExplicitRelation(team, AOTeam.class, new AOIdentifiableImpl.IRelationCallback<AOTeam>(){

            @Override
            public void apply(AOTeam dbTeam) {
                AOWorkItemImpl.this.data.setAOTeam(dbTeam);
            }
        });
    }

    public Optional<ITeam> getTeam() {
        return Optional.fromNullable((Object)this.data.getAOTeam());
    }

    public boolean canHaveParent() {
        return this.getWorkItemType().canHaveParent();
    }

    public WorkItemType getWorkItemType() {
        return WorkItemType.fromCode(this.data.getType());
    }

    public void setSprint(ISprint sprint) {
        this.setExplicitRelation(sprint, AOSprint.class, new AOIdentifiableImpl.IRelationCallback<AOSprint>(){

            @Override
            public void apply(AOSprint dbSprint) {
                AOWorkItemImpl.this.data.setAOSprint(dbSprint);
            }
        });
    }

    public Optional<ISprint> getSprint() {
        return Optional.fromNullable((Object)this.data.getAOSprint());
    }

    public boolean isStory() {
        return this.getWorkItemType() == WorkItemType.Story;
    }

    public boolean isEpic() {
        return this.getWorkItemType() == WorkItemType.Epic;
    }

    public boolean isInitiative() {
        return this.getWorkItemType() == WorkItemType.Initiative;
    }
}

