/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.stages;

import com.google.common.collect.Iterables;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOStage;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtils;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtilsCallback;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.skills.RestStage;
import com.radiantminds.roadmap.common.rest.utils.IPercentableCallback;
import com.radiantminds.roadmap.common.rest.utils.PercentageUtils;
import java.util.List;
import javax.ws.rs.core.Response;

public interface PlanStageServiceHandler {
    @AuthorizedPlanReadAccess
    public Response getAllStages(EntityContext<IPlan> var1) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response rankStage(EntityContext<IPlan> var1, RestRank var2) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response addStageToPlan(EntityContext<IPlan> var1, RestStage var2) throws Exception;

    public static class Impl
    implements PlanStageServiceHandler {
        private final PortfolioStagePersistence stagePersistence;
        private final SubCollectionUtils subCollectionUtils;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, PortfolioStagePersistence stagePersistence, PortfolioWorkItemPersistence workItemPersistence) {
            this.stagePersistence = stagePersistence;
            this.subCollectionUtils = new SubCollectionUtils(activeObjectsUtilities, workItemPersistence);
        }

        @Override
        public Response getAllStages(EntityContext<IPlan> entityContext) throws Exception {
            List<IStage> stages = this.stagePersistence.listCustom(entityContext.getEntityId());
            return entityContext.okForList(Iterables.toArray(ToRest.transferList(RestStage.class, IStage.class, stages), RestStage.class));
        }

        @Override
        public Response addStageToPlan(EntityContext<IPlan> entityContext, RestStage newStage) throws Exception {
            return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AOStage.class, "plan", newStage, new SubCollectionUtilsCallback.Adapter<IPlan, IStage, RestStage>(){
                private ModificationResult persistResult = null;

                @Override
                public void setParent(IPlan parent, IStage entity) {
                    entity.setPlan(parent);
                }

                @Override
                public IStage persist(IStage entity) throws Exception {
                    IStage stage = stagePersistence.persist(entity);
                    this.persistResult = PercentageUtils.adaptToItemAdd(stage.getPlan(), stage, IPercentableCallback.STAGE, stagePersistence);
                    return stage;
                }

                @Override
                public IStage get(String id) throws Exception {
                    return (IStage)stagePersistence.get(id);
                }

                @Override
                public ModificationResult buildModificationResult(IStage stored) throws Exception {
                    return this.persistResult;
                }
            });
        }

        @Override
        public Response rankStage(EntityContext<IPlan> entityContext, RestRank rank) throws Exception {
            return this.subCollectionUtils.rankEntity(entityContext, AOStage.class, this.stagePersistence, "plan", rank);
        }
    }
}

