/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.utils.estimate;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimateBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class EstimateData {
    private final String id;
    private Double selfValue;
    private Double sum;
    private Double percentOfSum;
    private List<EstimateData> subEstimates;

    private EstimateData(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Double getSelfValue() {
        return this.selfValue;
    }

    public Double getSum() {
        return this.sum;
    }

    public Double getPercentOfSum() {
        return this.percentOfSum;
    }

    public List<EstimateData> getSubEstimates() {
        return this.subEstimates;
    }

    private void setSelfValue(Double selfValue) {
        this.selfValue = selfValue;
    }

    private void setSum(Double sum) {
        this.sum = sum;
    }

    private void setPercentOfSum(Double percentOfSum) {
        this.percentOfSum = percentOfSum;
    }

    private void setSubEstimates(List<EstimateData> subEstimates) {
        this.subEstimates = subEstimates;
    }

    public static EstimateData createFrom(IPlan plan, final IEstimateBlock estimates) {
        return EstimateData.createFrom(plan, EstimateData.getEstimateValue(estimates.getTotal()), new Function<IStage, Double>(){

            public Double apply(@Nullable IStage stage) {
                return EstimateData.getEstimateValue((Optional<IEstimate>)estimates.getEstimateForStage(stage.getId()));
            }
        }, new Function<ISkill, Double>(){

            public Double apply(@Nullable ISkill skill) {
                return EstimateData.getEstimateValue((Optional<IEstimate>)estimates.getEstimateForSkill(skill.getId()));
            }
        });
    }

    public static EstimateData createForStagePercentages(IPlan plan, final Map<String, Double> stagePercentages, final double total) {
        return EstimateData.createFrom(plan, null, new Function<IStage, Double>(){

            public Double apply(@Nullable IStage stage) {
                double percentage = (Double)MoreObjects.firstNonNull(stagePercentages.get(stage.getId()), (Object)0.0);
                return total * percentage;
            }
        }, null);
    }

    private static EstimateData createFrom(IPlan plan, Double totalEstimate, final Function<IStage, Double> stageEstimateFunction, final Function<ISkill, Double> skillEstimateFunction) {
        EstimateData root = new EstimateData("total");
        if (totalEstimate != null) {
            root.setSelfValue(totalEstimate);
        } else if (plan.getStages().size() > 0) {
            ArrayList stageNodes = Lists.newArrayList((Iterable)Iterables.transform(plan.getStages(), (Function)new Function<IStage, EstimateData>(){

                public EstimateData apply(@Nullable IStage stage) {
                    return EstimateData.createFrom(stage, (Function<IStage, Double>)stageEstimateFunction, (Function<ISkill, Double>)skillEstimateFunction);
                }
            }));
            root.setSubEstimates(stageNodes);
        } else {
            root.setSelfValue(0.0);
        }
        EstimateData.aggregateSums(root);
        EstimateData.splitPercentages(root);
        return root;
    }

    private static EstimateData createFrom(IStage stage, Function<IStage, Double> stageEstimateFunction, final Function<ISkill, Double> skillEstimateFunction) {
        EstimateData stageNode = new EstimateData(stage.getId());
        Double stageEstimate = (Double)stageEstimateFunction.apply((Object)stage);
        if (stageEstimate != null) {
            stageNode.setSelfValue(stageEstimate);
        } else if (stage.getSkills().size() > 0) {
            ArrayList skillNodes = Lists.newArrayList((Iterable)Iterables.transform(stage.getSkills(), (Function)new Function<ISkill, EstimateData>(){

                public EstimateData apply(@Nullable ISkill skill) {
                    return EstimateData.createFrom(skill, (Function<ISkill, Double>)skillEstimateFunction);
                }
            }));
            stageNode.setSubEstimates(skillNodes);
        } else {
            stageNode.setSelfValue(0.0);
        }
        return stageNode;
    }

    private static EstimateData createFrom(ISkill skill, Function<ISkill, Double> skillEstimateFunction) {
        EstimateData skillNode = new EstimateData(skill.getId());
        Double skillEstimate = (Double)skillEstimateFunction.apply((Object)skill);
        if (skillEstimate != null) {
            skillNode.setSelfValue(skillEstimate);
        } else {
            skillNode.setSelfValue(0.0);
        }
        return skillNode;
    }

    private static Double getEstimateValue(Optional<IEstimate> estimate) {
        if (estimate != null && estimate.isPresent()) {
            return ((IEstimate)estimate.get()).getEstimate();
        }
        return null;
    }

    private static void aggregateSums(EstimateData node) {
        if (node.getSubEstimates() != null) {
            double sum = 0.0;
            for (EstimateData subNode : node.getSubEstimates()) {
                EstimateData.aggregateSums(subNode);
                if (subNode.getSelfValue() != null) {
                    sum += subNode.getSelfValue().doubleValue();
                    continue;
                }
                sum += subNode.getSum().doubleValue();
            }
            node.setSum(sum);
        }
    }

    private static void splitPercentages(EstimateData node) {
        Double sum = node.getSum();
        if (sum != null) {
            for (EstimateData subNode : node.getSubEstimates()) {
                if (sum > 0.0) {
                    double entry = subNode.getSelfValue() != null ? subNode.getSelfValue().doubleValue() : subNode.getSum().doubleValue();
                    subNode.setPercentOfSum(entry / sum);
                } else {
                    subNode.setPercentOfSum(0.0);
                }
                EstimateData.splitPercentages(subNode);
            }
        }
    }
}

