/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.InternalAgileRankService;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.atlassian.rm.common.bridges.agile.rank.AgileRankOperationResponse;
import com.atlassian.rm.common.bridges.agile.rank.AgileRankServiceBridge;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;

abstract class BaseAgileRankServiceBridgeJpo
implements AgileRankServiceBridge {
    private static final Log LOGGER = Log.with(BaseAgileRankServiceBridgeJpo.class);
    private final InternalAgileRankService internalAgileRankService;

    public BaseAgileRankServiceBridgeJpo(InternalAgileRankService internalAgileRankService) {
        this.internalAgileRankService = internalAgileRankService;
    }

    @Override
    public AgileRankOperationResponse rankFirst(List<Long> ids) throws Exception {
        Preconditions.checkNotNull(ids);
        LOGGER.debug("received rank first in DefaultRank domain: %s", Iterables.toString(ids));
        AgileRankOperationResponse response = this.internalAgileRankService.rankFirst(ids, this.getDefaultRankDomain());
        LOGGER.debug("created response: %s", response);
        return response;
    }

    @Override
    public AgileRankOperationResponse rankLast(List<Long> ids) throws Exception {
        Preconditions.checkNotNull(ids);
        LOGGER.debug("received rank last in DefaultRank domain: %s", Iterables.toString(ids));
        AgileRankOperationResponse response = this.internalAgileRankService.rankLast(ids, this.getDefaultRankDomain());
        LOGGER.debug("created response: %s", response);
        return response;
    }

    @Override
    public AgileRankOperationResponse rankBefore(List<Long> ids, long anchorId) throws Exception {
        Preconditions.checkNotNull(ids);
        LOGGER.debug("received rank before %d in DefaultRank domain: %s", anchorId, Iterables.toString(ids));
        AgileRankOperationResponse response = this.internalAgileRankService.rankBefore(ids, anchorId, this.getDefaultRankDomain());
        LOGGER.debug("created response: %s", response);
        return response;
    }

    @Override
    public AgileRankOperationResponse rankAfter(List<Long> ids, long anchorId) throws Exception {
        Preconditions.checkNotNull(ids);
        LOGGER.debug("received rank after %d in DefaultRank domain: %s", anchorId, Iterables.toString(ids));
        AgileRankOperationResponse response = this.internalAgileRankService.rankAfter(ids, anchorId, this.getDefaultRankDomain());
        LOGGER.debug("created response: %s", response);
        return response;
    }

    @Override
    public ImmutableMap<Long, String> getRankValues(Collection<Long> ids) throws Exception {
        Preconditions.checkNotNull(ids);
        LOGGER.debug("received rank value request in DefaultRank domain: %s", Iterables.toString(ids));
        ImmutableMap<Long, String> response = this.internalAgileRankService.getRankValues(ids, this.getDefaultRankDomain());
        LOGGER.debug("created response: %s", Iterables.toString((Iterable)response.entrySet()));
        return response;
    }

    @Override
    public void delete(long id) throws Exception {
        Preconditions.checkNotNull((Object)id);
        LOGGER.debug("received rank delete request in DefaultRank domain: %s", String.valueOf(id));
        this.internalAgileRankService.delete(id);
    }

    @Override
    public ImmutableList<Long> sort(Collection<Long> ids) throws Exception {
        Preconditions.checkNotNull(ids);
        LOGGER.debug("received sort request in DefaultRank domain: %s", Iterables.toString(ids));
        ImmutableList<Long> response = this.internalAgileRankService.sort(ids, this.getDefaultRankDomain());
        LOGGER.debug("created response: %s", Iterables.toString(response));
        return response;
    }

    protected abstract long getDefaultRankDomain() throws AgileNotAvailableException, AgileCustomFieldNotAvailableException;
}

