/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.license;

import com.atlassian.extras.common.LicenseException;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.license.AgileLicenseServiceBridge;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessor;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.atlassian.rm.common.bridges.api.plugins.access.ServiceCallback;
import com.pyxis.greenhopper.jira.license.GreenHopperLicenseManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.license.AgileLicenseServiceBridgeImpl")
@SupportedVersions(all=true)
public class AgileLicenseServiceBridgeImpl
implements AgileLicenseServiceBridge {
    private static final Log LOGGER = Log.with(AgileLicenseServiceBridgeImpl.class);
    private final BundleServiceAccessorProvider bundleServiceAccessorProvider;
    private boolean enabled;

    @Autowired
    public AgileLicenseServiceBridgeImpl(BundleServiceAccessorProvider bundleServiceAccessorProvider) {
        this.bundleServiceAccessorProvider = bundleServiceAccessorProvider;
        this.enabled = true;
    }

    @Override
    public boolean isLicensed() throws AgileNotAvailableException {
        try {
            BundleServiceAccessor<GreenHopperLicenseManager> serviceAccessor = this.bundleServiceAccessorProvider.createServiceAccessor(GreenHopperLicenseManager.class);
            return serviceAccessor.perform(new ServiceCallback<GreenHopperLicenseManager, Boolean>(){

                @Override
                public Boolean perform(GreenHopperLicenseManager licenseManager) {
                    try {
                        licenseManager.verify();
                        return true;
                    }
                    catch (LicenseException licenseException) {
                        if (!AgileLicenseServiceBridgeImpl.this.enabled) {
                            return true;
                        }
                        LOGGER.debug("Agile license exception: " + licenseException.getMessage(), new Object[0]);
                        return false;
                    }
                }
            });
        }
        catch (Exception e) {
            throw new AgileNotAvailableException(e);
        }
    }

    @Override
    public void setCheckEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

