/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.persistence;

import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.persistence.DefaultJiraDatabaseConnection;
import com.atlassian.rm.common.bridges.jira.persistence.JiraDatabaseConnection;
import com.atlassian.rm.common.bridges.jira.persistence.JiraDatabaseConnectionListener;
import com.atlassian.rm.common.bridges.jira.persistence.JiraDatabaseProvider;
import com.atlassian.rm.common.bridges.jira.persistence.JiraPersistenceFunction;
import com.atlassian.rm.common.pkqdsl.legacy.ConnectionProvider;
import com.atlassian.rm.common.pkqdsl.legacy.DatabaseCompatibilityKit;
import com.atlassian.rm.common.pkqdsl.legacy.DialectProvider;
import com.google.common.collect.Lists;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLInsertClause;
import java.sql.Connection;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.persistence.JiraDatabaseProviderBridgeImpl")
@SupportedVersions(all=true)
public class JiraDatabaseProviderBridgeImpl
implements JiraDatabaseProvider {
    private final ConnectionProvider legacyConnectionProvider;
    private final DialectProvider legacyDialectProvider;
    private final DatabaseCompatibilityKit databaseCompatibilityKit;

    @Autowired
    JiraDatabaseProviderBridgeImpl(ConnectionProvider legacyConnectionProvider, DialectProvider legacyDialectProvider, DatabaseCompatibilityKit databaseCompatibilityKit) {
        this.legacyConnectionProvider = legacyConnectionProvider;
        this.legacyDialectProvider = legacyDialectProvider;
        this.databaseCompatibilityKit = databaseCompatibilityKit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(JiraPersistenceFunction<T> function) throws Exception {
        T retVal;
        Connection connection = this.legacyConnectionProvider.borrowConnection();
        ArrayList outerListeners = Lists.newArrayList();
        try {
            DialectProvider.Config dialectConfig = this.legacyDialectProvider.getDialectConfig(connection);
            SQLQueryFactory factory = new SQLQueryFactory(dialectConfig.getConfiguration(), () -> connection);
            DefaultJiraDatabaseConnection jiraDatabaseConnection = new DefaultJiraDatabaseConnection(factory, connection);
            retVal = function.perform(jiraDatabaseConnection);
            for (JiraDatabaseConnectionListener listener : jiraDatabaseConnection.getListeners()) {
                listener.onBeforeCommit();
                outerListeners.add(listener);
            }
            connection.commit();
        }
        finally {
            this.legacyConnectionProvider.returnConnection(connection);
        }
        for (JiraDatabaseConnectionListener listener : outerListeners) {
            listener.onAfterTransaction();
        }
        return retVal;
    }

    @Override
    public <T> T executeWithKey(JiraDatabaseConnection connection, SQLInsertClause insertClause, Class<T> idClass) throws Exception {
        return this.databaseCompatibilityKit.executeWithKey(connection.getJdbcConnection(), insertClause, idClass);
    }
}

