/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.FieldConfigurationBuilder;
import com.google.common.base.Supplier;

public interface Field {
    public String getName();

    public String getStringValue();

    public static enum StandardConfigurations implements Configuration
    {
        ANALYZED(new FieldConfigurationBuilder().build()),
        NOT_ANALYZED(new FieldConfigurationBuilder().setAnalyzed(false).build()),
        NOT_ANALYZED_NO_NORMS(new FieldConfigurationBuilder().setAnalyzed(false).setOmitNorms(true).build());

        private final Configuration configuration;

        private StandardConfigurations(Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        public boolean isAnalyzed() {
            return this.configuration.isAnalyzed();
        }

        @Override
        public boolean isOmitNorms() {
            return this.configuration.isOmitNorms();
        }

        @Override
        public boolean isStored() {
            return this.configuration.isStored();
        }

        @Override
        public boolean isSortable() {
            return this.configuration.isSortable();
        }

        @Override
        public boolean isMultiValued() {
            return this.configuration.isMultiValued();
        }
    }

    public static interface Configuration {
        public static final Supplier<Builder> BUILDER = new Supplier<Builder>(){

            public Builder get() {
                return new FieldConfigurationBuilder();
            }
        };

        public boolean isAnalyzed();

        public boolean isOmitNorms();

        public boolean isStored();

        public boolean isSortable();

        public boolean isMultiValued();

        public static interface Builder {
            public Builder set(Configuration var1);

            public Builder setAnalyzed(boolean var1);

            public Builder setOmitNorms(boolean var1);

            public Builder setStored(boolean var1);

            public Builder setSortable(boolean var1);

            public Builder setMultiValued(boolean var1);

            public Configuration build();
        }
    }

    public static interface Factory {
        public Field createTextField(String var1, String var2, Configuration var3);

        public Field createBooleanField(String var1, boolean var2);

        public Field createNumericField(String var1, long var2);

        public Field createNumericField(String var1, double var2);
    }
}

