/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.EpisodeState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IEpisodeState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class FixedScopeEpisodeState
implements IEpisodeState {
    private static final Log LOGGER = Log.with(FixedScopeEpisodeState.class);
    private Integer endTime = null;
    private Integer startTime;
    private Set<String> openStrictlyAssigned;
    private EpisodeState episodeState;
    private final Set<IEpisodeState> dependentEpisodeStates;
    private final Set<String> successfullItems = Sets.newHashSet();
    private final IEpisode episode;

    FixedScopeEpisodeState(@Nullable Integer startTime, @Nullable Integer endTime, Set<String> openStrictlyAssigned, EpisodeState episodeState, Set<IEpisodeState> dependentEpisodeStates, IEpisode episode) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.openStrictlyAssigned = openStrictlyAssigned;
        this.episodeState = episodeState;
        this.dependentEpisodeStates = dependentEpisodeStates;
        this.episode = episode;
    }

    @Override
    public void setFailedForItemNewEndTime(String itemId) {
        LogUtil.debug(LOGGER, "finished item %s as failed", itemId);
        this.stateTransition(itemId);
    }

    @Override
    public void setFinishedNewEndTime(String itemId, int end) {
        LogUtil.debug(LOGGER, "finished item %s with end time: %d", itemId, end);
        this.endTime = RmUtils.getOptionalMax(end, (Optional<Integer>)Optional.fromNullable((Object)this.endTime));
        this.successfullItems.add(itemId);
        this.stateTransition(itemId);
    }

    @Override
    public void predecessorHasEndTime(IEpisodeState precedingState) {
        LogUtil.debug(LOGGER, "preceding episode for %s ended with state %s", this.episode.getId(), precedingState);
        if (this.startTime == null) {
            this.startTime = this.calculateStart(precedingState);
            LogUtil.debug(LOGGER, "set start time: %d", this.startTime);
        }
        this.episodeState = FixedScopeEpisodeState.getState(this.startTime, this.openStrictlyAssigned.isEmpty());
        if (this.episodeState.equals((Object)EpisodeState.Empty)) {
            this.endTime = this.startTime;
            LogUtil.debug(LOGGER, "set end time: %d", this.endTime);
            for (IEpisodeState nextEpisodeState : this.dependentEpisodeStates) {
                nextEpisodeState.predecessorHasEndTime(this);
            }
        }
    }

    private int calculateStart(IEpisodeState precedingState) {
        if (precedingState.getState().equals((Object)EpisodeState.Empty)) {
            return Math.max(0, (Integer)precedingState.getStartTime().get() + (Integer)this.episode.getStartGap().or((Object)0));
        }
        return Math.max(0, (Integer)precedingState.getEndTime().get() + (Integer)this.episode.getStartGap().or((Object)1));
    }

    @Override
    public Optional<Integer> getEndTime() {
        return Optional.fromNullable((Object)this.endTime);
    }

    @Override
    public Optional<Integer> getStartTime() {
        return Optional.fromNullable((Object)this.startTime);
    }

    @Override
    public EpisodeState getState() {
        return this.episodeState;
    }

    @Override
    public IEpisode getEpisode() {
        return this.episode;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("episode", (Object)this.episode.getId()).add("endTime", (Object)this.endTime).add("startTime", (Object)this.startTime).add("openStrictlyAssigned", (Object)Iterables.toString(this.openStrictlyAssigned)).add("episodeState", (Object)this.episodeState).add("dependentEpisodeStates", this.dependentEpisodeStates).add("successfullItems", this.successfullItems).toString();
    }

    private void stateTransition(String itemId) {
        this.openStrictlyAssigned.remove(itemId);
        if (this.openStrictlyAssigned.isEmpty()) {
            if (this.successfullItems.isEmpty()) {
                LogUtil.debug(LOGGER, "set episode state to Empty for episode: %s", this.episode.getId());
                this.episodeState = EpisodeState.Empty;
                this.endTime = this.startTime;
            } else {
                LogUtil.debug(LOGGER, "set episode state to Optionals for episode: %s", this.episode.getId());
                this.episodeState = EpisodeState.Optionals;
            }
            for (IEpisodeState nextEpisodeState : this.dependentEpisodeStates) {
                nextEpisodeState.predecessorHasEndTime(this);
            }
        }
    }

    public static IEpisodeState initialize(IEpisode episode, @Nullable Set<IEpisodeState> successorStates, @Nullable Integer startTime, @Nullable Set<IProcessingItem> assigned) {
        Preconditions.checkNotNull((Object)episode, (Object)"episode must not be null");
        LogUtil.debug(LOGGER, "create instance for episode: %s", episode);
        if (successorStates == null) {
            successorStates = Sets.newHashSet();
        }
        Set<String> openStrict = RmIdentifiableUtils.getIds(assigned);
        EpisodeState state = FixedScopeEpisodeState.getState(startTime, openStrict.isEmpty());
        Integer end = null;
        if (state.equals((Object)EpisodeState.Empty)) {
            end = startTime;
        }
        FixedScopeEpisodeState instance = new FixedScopeEpisodeState(startTime, end, openStrict, state, successorStates, episode);
        if (state.equals((Object)EpisodeState.Empty) && end != null) {
            for (IEpisodeState successorState : successorStates) {
                successorState.predecessorHasEndTime(instance);
            }
        }
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return instance;
    }

    private static EpisodeState getState(@Nullable Integer startTime, boolean empty) {
        if (startTime == null) {
            return EpisodeState.NotStarted;
        }
        if (empty) {
            return EpisodeState.Empty;
        }
        return EpisodeState.Strictly;
    }
}

