/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.EpisodeState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IEpisodeState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IItemAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ProcessingItemType;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
class ItemAssignmentProblem
implements IItemAssignmentProblem {
    private static final Log LOGGER = Log.with(ItemAssignmentProblem.class);
    private final IProcessingItem item;
    private final int lowerTimeBound;
    private final int causalReleaseTime;
    private final boolean schedulingEnforced;
    private final IEpisode episode;
    private final int upperTimeBound;
    private final boolean planningHorizonReached;

    ItemAssignmentProblem(IProcessingItem item, int lowerTimeBound, int upperTimeBound, int causalReleaseTime, boolean schedulingEnforced, boolean planningHorizonReached, IEpisode episode) {
        Preconditions.checkNotNull((Object)item, (Object)"item must not be null");
        Preconditions.checkArgument((lowerTimeBound >= 0 ? 1 : 0) != 0, (Object)"time bound must not be negative");
        Preconditions.checkArgument((causalReleaseTime >= 0 ? 1 : 0) != 0, (Object)"causal release time must not be negative");
        Preconditions.checkNotNull((Object)episode, (Object)"episode must not be null");
        this.item = item;
        this.lowerTimeBound = lowerTimeBound;
        this.upperTimeBound = upperTimeBound;
        this.causalReleaseTime = causalReleaseTime;
        this.schedulingEnforced = schedulingEnforced;
        this.planningHorizonReached = planningHorizonReached;
        this.episode = episode;
    }

    @Override
    public String getId() {
        return this.item.getId();
    }

    @Override
    public int getLowerTimeBound() {
        return this.lowerTimeBound;
    }

    @Override
    public IEpisode getProjectEpisode() {
        return this.episode;
    }

    @Override
    public ProcessingItemType getProcessingItemType() {
        return this.item.getProcessingItemType();
    }

    @Override
    public IProcessingItem getProcessingItem() {
        return this.item;
    }

    @Override
    public boolean isSchedulingEnforced() {
        return this.schedulingEnforced;
    }

    @Override
    public int getCausalReleaseTime() {
        return this.causalReleaseTime;
    }

    @Override
    public int getUpperTimeBound() {
        return this.upperTimeBound;
    }

    @Override
    public boolean isUpperTimeBoundPlanningHorizon() {
        return this.planningHorizonReached;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("item", (Object)this.item.getId()).add("lowerTimeBound", this.lowerTimeBound).add("causalReleaseTime", this.causalReleaseTime).add("schedulingEnforced", this.schedulingEnforced).add("episode", (Object)this.episode.getId()).add("upperTimeBound", this.upperTimeBound).add("planningHorizonReached", this.planningHorizonReached).toString();
    }

    public static Optional<IItemAssignmentProblem> tryCreateInstance(IProcessingItem item, IEpisodeState episodeState, int causalReleaseTime, boolean enforced, int planningHorizon) {
        LogUtil.debug(LOGGER, "try to create problem for item: %s", item.getId());
        if (episodeState.getState().equals((Object)EpisodeState.NotStarted)) {
            LogUtil.debug(LOGGER, "corresponding episode not started");
            return Optional.absent();
        }
        int lower = Math.max(causalReleaseTime, (Integer)episodeState.getStartTime().get());
        int upper = ItemAssignmentProblem.getUpperTimeBound(enforced, episodeState, planningHorizon);
        boolean horizonReached = upper >= planningHorizon;
        ItemAssignmentProblem instance = new ItemAssignmentProblem(item, lower, upper, causalReleaseTime, enforced, horizonReached, episodeState.getEpisode());
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return Optional.of((Object)instance);
    }

    private static int getUpperTimeBound(boolean enforced, IEpisodeState episodeState, int planningHorizon) {
        if (enforced) {
            return planningHorizon;
        }
        int episodeHorizon = (Integer)episodeState.getEndTime().or((Object)planningHorizon);
        return Math.min(planningHorizon, episodeHorizon);
    }
}

