/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import java.util.Set;

class AssignmentResourceWrapper
implements AssignmentResource {
    private final IMutableResource resource;
    private final WorkSlotsDefinition workSlotsDefinition;
    private final Set<IResourceType> types;
    private final float cost;

    private AssignmentResourceWrapper(IMutableResource resource, WorkSlotsDefinition workSlotsDefinition, Set<IResourceType> types, float cost) {
        this.resource = resource;
        this.workSlotsDefinition = workSlotsDefinition;
        this.types = types;
        this.cost = cost;
    }

    @Override
    public String getId() {
        return this.resource.getId();
    }

    @Override
    public String getSortKey() {
        return this.resource.getSortKey();
    }

    @Override
    public float getUnassignedWorkInWorkSlot(int slotIndex) {
        return this.resource.getUnassignedWorkInWorkSlot(slotIndex);
    }

    @Override
    public float getRestrictedAvailability(int slotIndex) {
        return this.resource.getRestrictedAvailability(slotIndex);
    }

    @Override
    public boolean isWorkScheduled(int timeIndex) {
        return (double)this.resource.getAssignedWorkInWorkSlot(timeIndex) > 0.0;
    }

    @Override
    public boolean isAvailableInWorkSlot(int slotIndex) {
        return this.resource.isAvailableInWorkSlot(slotIndex);
    }

    @Override
    public Set<IResourceType> getTypes() {
        return this.types;
    }

    @Override
    public float getCost() {
        return this.cost;
    }

    public static AssignmentResourceWrapper createInstance(WorkSlotsDefinition workSlotsDefinition, IMutableResource resource, float cost) {
        return new AssignmentResourceWrapper(resource, workSlotsDefinition, resource.getResourceTypes(), cost);
    }

    @Override
    public boolean isLimitedAvailable() {
        return !this.resource.isUnlimitedAvailable();
    }

    @Override
    public int getFirstRegularTimeIndex() {
        return this.workSlotsDefinition.getNextWorkSlotWithFullPresence(this.resource.getFirstRegularTimeStep()).getIndex();
    }
}

