/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ITeamVelocityFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.util.function.PositiveLinearFunction;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LinearTeamVelocityFunction
implements ITeamVelocityFunction {
    private final PositiveLinearFunction function;
    private final WorkSlotsDefinition workSlotsDefinition;
    private final TimeStepPresenceFunction presenceFunction;

    public LinearTeamVelocityFunction(float velocity, float increment, WorkSlotsDefinition workSlotsDefinition, TimeStepPresenceFunction presenceFunction) {
        this(new PositiveLinearFunction(velocity, increment), workSlotsDefinition, presenceFunction);
    }

    LinearTeamVelocityFunction(PositiveLinearFunction function, WorkSlotsDefinition workSlotsDefinition, TimeStepPresenceFunction presenceFunction) {
        this.function = function;
        this.workSlotsDefinition = workSlotsDefinition;
        this.presenceFunction = presenceFunction;
    }

    @Override
    public float getVelocity(int slotIndex) {
        int defaultWorkDaysInSlot = this.presenceFunction.getWeeklyWorkDays() * this.workSlotsDefinition.getDefaultSlotLength() / 7;
        if (defaultWorkDaysInSlot == 0) {
            return 0.0f;
        }
        int workDaysInSlot = this.presenceFunction.getPresenceSum(this.workSlotsDefinition.getWorkSlotWithIndex(slotIndex));
        float factor = (float)workDaysInSlot / (float)defaultWorkDaysInSlot;
        return factor * this.function.getAt(slotIndex).floatValue();
    }

    @Override
    public boolean isPositiveEnding() {
        return this.function.isPositiveEnding();
    }
}

