/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IStepWiseResourcePresence;
import com.atlassian.rm.jpo.scheduling.util.function.BoundDiscreteBooleanFunction;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DefaultAvailableResourcePresenceFunction
implements IStepWiseResourcePresence {
    private final TimeStepPresenceFunction timeStepPresenceFunction;
    private final Optional<BoundDiscreteBooleanFunction> absenceFunction;

    public DefaultAvailableResourcePresenceFunction(TimeStepPresenceFunction timeStepPresenceFunction) {
        this(timeStepPresenceFunction, (Optional<BoundDiscreteBooleanFunction>)Optional.absent());
    }

    public DefaultAvailableResourcePresenceFunction(TimeStepPresenceFunction timeStepPresenceFunction, Optional<BoundDiscreteBooleanFunction> absenceFunction) {
        this.timeStepPresenceFunction = (TimeStepPresenceFunction)Preconditions.checkNotNull((Object)timeStepPresenceFunction);
        this.absenceFunction = (Optional)Preconditions.checkNotNull(absenceFunction);
    }

    @Override
    public int getFirstRegularTimeStep() {
        if (!this.absenceFunction.isPresent()) {
            return 0;
        }
        return ((BoundDiscreteBooleanFunction)this.absenceFunction.get()).getUpperSpecificationBound() + 1;
    }

    @Override
    public boolean isPresent(int timeStep) {
        boolean baseValue = this.timeStepPresenceFunction.getAt(timeStep);
        if (this.absenceFunction.isPresent() && ((BoundDiscreteBooleanFunction)this.absenceFunction.get()).contains(timeStep)) {
            boolean absenceValue = ((BoundDiscreteBooleanFunction)this.absenceFunction.get()).getAt(timeStep);
            return !absenceValue && baseValue;
        }
        return baseValue;
    }

    @Override
    public boolean isPositiveEnding() {
        return true;
    }
}

