/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;

public class Portfolio2PlanIds {
    public static final String SUFFIX = "-2";
    private static Predicate<String> IS = new Predicate<String>(){

        public boolean apply(String s) {
            return s.endsWith(Portfolio2PlanIds.SUFFIX);
        }
    };
    private static Function<Long, String> TO = new Function<Long, String>(){

        public String apply(Long id) {
            return Portfolio2PlanIds.format(id);
        }
    };
    private static Function<String, Long> FROM = new Function<String, Long>(){

        public Long apply(String s) {
            return Long.parseLong(s.substring(0, s.length() - Portfolio2PlanIds.SUFFIX.length()));
        }
    };

    public static String format(long planId) {
        return planId + SUFFIX;
    }

    public static Predicate<String> is() {
        return IS;
    }

    public static boolean is(String id) {
        return IS.apply((Object)id);
    }

    public static Function<Long, String> to() {
        return TO;
    }

    public static Function<String, Long> from() {
        return FROM;
    }
}

