/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.time;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.generator.time.IReleaseConfiguration;
import com.radiantminds.roadmap.common.data.generator.time.IStreamConfiguration;
import com.radiantminds.roadmap.common.data.generator.time.ITimePlanConfiguration;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TimePlanConfiguration
implements ITimePlanConfiguration {
    private final List<IStreamConfiguration> streamConfigurations;
    private final List<IReleaseConfiguration> releaseConfigurations;

    public TimePlanConfiguration(List<IStreamConfiguration> streamConfigurations, List<IReleaseConfiguration> releaseConfigurations) {
        this.streamConfigurations = streamConfigurations;
        this.releaseConfigurations = releaseConfigurations;
    }

    public TimePlanConfiguration() {
        this(Lists.newArrayList(), Lists.newArrayList());
    }

    public TimePlanConfiguration(IStreamConfiguration releaseStreamsConfiguration) {
        this(Lists.newArrayList((Object[])new IStreamConfiguration[]{releaseStreamsConfiguration}), Lists.newArrayList());
    }

    public TimePlanConfiguration(List<IReleaseConfiguration> releaseConfigurations) {
        this(Lists.newArrayList(), releaseConfigurations);
    }

    @Override
    public List<IStreamConfiguration> getStreamConfigurations() {
        return this.streamConfigurations;
    }

    @Override
    public List<IReleaseConfiguration> getDefaultStreamReleaseConfigurations() {
        return this.releaseConfigurations;
    }

    public static TimePlanConfiguration createWithSingleStream(List<IReleaseConfiguration> releaseConfigurations) {
        TimePlanConfiguration instance = new TimePlanConfiguration(releaseConfigurations);
        return instance;
    }
}

