/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.plans;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.plans.INonWorkingDay;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.entities.themes.ITheme;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOIdentifiableImpl;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.rest.entities.plans.RestPlanConfiguration;
import java.util.List;

public class AOPlanImpl
extends AOIdentifiableImpl {
    private final AOPlan plan;

    public AOPlanImpl(AOPlan plan) {
        super(plan);
        this.plan = plan;
    }

    public void clearReplanning(ActiveObjectsUtilities activeObjectsUtilities) {
        this.plan.setAOReplanningDate(null);
    }

    public void applyReplanning(ActiveObjectsUtilities activeObjectsUtilities, Long replanningDate) {
        if (replanningDate != null) {
            this.plan.setAODate(replanningDate);
        }
    }

    public Optional<Long> getDate() {
        return Optional.fromNullable((Object)this.plan.getAODate());
    }

    public void setDate(Long date) {
        this.plan.setAODate(date);
    }

    public Optional<Long> getReplanningDate() {
        return Optional.fromNullable((Object)this.plan.getAOReplanningDate());
    }

    public void setReplanningDate(Long date) {
        this.plan.setAOReplanningDate(date);
    }

    public List<IStage> getStages() {
        return Lists.newArrayList((Object[])this.plan.getAOStages());
    }

    public List<ITheme> getThemes() {
        return Lists.newArrayList((Object[])this.plan.getAOThemes());
    }

    public List<ITeam> getTeams() {
        return Lists.newArrayList((Object[])this.plan.getAOTeams());
    }

    public List<IWorkItem> getWorkItems() {
        return Lists.newArrayList((Object[])this.plan.getAOWorkItems());
    }

    public List<IStream> getStreams() {
        Object[] streams = this.plan.getAOStreams();
        if (streams == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])streams);
    }

    public List<IPerson> getPersons() {
        return Lists.newArrayList((Object[])this.plan.getAOPersons());
    }

    public List<INonWorkingDay> getNonWorkingDays() {
        return Lists.newArrayList((Object[])this.plan.getAONonWorkingDays());
    }

    public IPlanConfiguration getPlanConfiguration() {
        return new RestPlanConfiguration(this.plan.getAoPlanConfiguration());
    }
}

