/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.filter;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.filter.IWorkItemFilter;
import com.radiantminds.roadmap.common.filter.WorkItemSolutionFilterResult;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolution;
import com.radiantminds.roadmap.common.scheduling.Calculation;
import java.util.List;
import java.util.Set;

public class WorkItemSolutionFilter {
    public static WorkItemSolutionFilterResult applySolutionFilter(IWorkItemFilter filter, Optional<Calculation> calculation) throws Exception {
        if (!calculation.isPresent()) {
            return WorkItemSolutionFilterResult.createDefault();
        }
        if (((Calculation)calculation.get()).getSchedulingVersion() == null) {
            return WorkItemSolutionFilterResult.createDefault();
        }
        RestSchedulingSolution planSolution = ((Calculation)calculation.get()).getTransferableSolution();
        if (planSolution == null) {
            return WorkItemSolutionFilterResult.createDefault();
        }
        List<String> teamIds = filter.getTeamIds();
        Set<String> resourceIdsForTeamIds = planSolution.getResourceIdsForTeamIds(teamIds);
        Set<String> itemsOfTeams = planSolution.getWorkItemIdsForResourceIds(resourceIdsForTeamIds);
        List<String> releaseIds = filter.getReleaseIds();
        Set<String> itemsOfReleases = planSolution.getWorkItemIdsForReleaseIds(releaseIds);
        Set<String> itemsOfDateRange = planSolution.getWorkItemIdsForDateRange(filter.getFromDate(), filter.getToDate(), filter.getReleaseIds(), resourceIdsForTeamIds, filter.getStageIds());
        return new WorkItemSolutionFilterResult(itemsOfTeams, itemsOfReleases, itemsOfDateRange);
    }
}

