/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers;

import com.atlassian.pocketknife.api.querydsl.ConnectionProvider;
import com.atlassian.rm.common.bridges.jira.license.LicenseData;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.licenses.LicenseExtension;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.ClientIdCache;
import com.radiantminds.roadmap.common.handlers.DatabaseContext;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.MethodEntityContextProvider;
import com.radiantminds.roadmap.common.handlers.NotAuthorizedException;
import com.radiantminds.roadmap.common.handlers.NotFoundException;
import com.radiantminds.roadmap.common.handlers.PluginLevelPermissionChecker;
import com.radiantminds.roadmap.common.handlers.SecureBulkEntityContextInitializer;
import com.radiantminds.roadmap.common.handlers.SecureEntityContextInitializer;
import com.radiantminds.roadmap.common.handlers.SecurityAnnotations;
import com.radiantminds.roadmap.common.handlers.VersionMismatchException;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ws.rs.core.Response;

public class SecuredInvocationHandler<U extends IIdentifiable, T>
implements InvocationHandler {
    private final T handler;
    private final IEntityPersistence<U> entityPersistence;
    private final PortfolioPlanPersistence planPersistence;
    private final PlanPermissions planPermissionHandler;
    private final PluginPermissions pluginPermissionHandler;
    private final LicenseExtension licenseExtension;
    private final ConnectionProvider connectionProvider;
    private final ClientIdCache clientIdCache;

    @Deprecated
    public SecuredInvocationHandler(T handler, IEntityPersistence<U> persistence, PortfolioPlanPersistence planPersistence, PlanPermissions planPermissionHandler, PluginPermissions pluginPermissionHandler, LicenseExtension licenseExtension, ConnectionProvider connectionProvider, ClientIdCache clientIdCache) {
        this.handler = handler;
        this.entityPersistence = persistence;
        this.planPersistence = planPersistence;
        this.planPermissionHandler = planPermissionHandler;
        this.pluginPermissionHandler = pluginPermissionHandler;
        this.licenseExtension = licenseExtension;
        this.connectionProvider = connectionProvider;
        this.clientIdCache = clientIdCache;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        LicenseData licenseData;
        SecurityAnnotations securityConfig = new SecurityAnnotations(method);
        MethodEntityContextProvider contextProvider = new MethodEntityContextProvider(method, args);
        if (this.licenseExtension != null && !(licenseData = this.licenseExtension.getLicenseData()).isValid()) {
            return Response.status((int)402).entity((Object)licenseData.getMessage()).build();
        }
        if (contextProvider.getDatabaseContext().isPresent()) {
            ((DatabaseContext)contextProvider.getDatabaseContext().get()).init(this.connectionProvider);
        }
        boolean isEntityAware = contextProvider.getEntityContext().isPresent() || contextProvider.getBulkEntityContext().isPresent();
        try {
            Optional<Response> response;
            if (!isEntityAware || securityConfig.requiresPluginLevelAuth()) {
                PluginLevelPermissionChecker.check(securityConfig, this.pluginPermissionHandler);
            }
            if (contextProvider.getEntityContext().isPresent()) {
                SecureEntityContextInitializer.initialize((EntityContext)contextProvider.getEntityContext().get(), this.entityPersistence, contextProvider.getDatabaseContext(), this.planPersistence, this.pluginPermissionHandler, this.planPermissionHandler, securityConfig, this.clientIdCache);
            } else if (contextProvider.getBulkEntityContext().isPresent() && (response = SecureBulkEntityContextInitializer.initialize((BulkEntityContext)contextProvider.getBulkEntityContext().get(), this.entityPersistence, this.planPersistence, this.pluginPermissionHandler, this.planPermissionHandler, securityConfig)).isPresent()) {
                return response.get();
            }
        }
        catch (NotFoundException e) {
            return ResponseBuilder.badRequest(RestMessaging.entityNotFound());
        }
        catch (VersionMismatchException e) {
            return ResponseBuilder.conflict(RestMessaging.error("version-conflict", String.format("Version mismatch; your version: '%d', server version: '%d'", e.getExceptedVersion(), e.getActualVersion())));
        }
        catch (NotAuthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            Object retVal = method.invoke(this.handler, args);
            if (contextProvider.getDatabaseContext().isPresent()) {
                ((DatabaseContext)contextProvider.getDatabaseContext().get()).commit();
            }
            Object object = retVal;
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            if (contextProvider.getDatabaseContext().isPresent()) {
                ((DatabaseContext)contextProvider.getDatabaseContext().get()).release();
            }
        }
    }
}

