/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.permissions;

import com.radiantminds.roadmap.api.PluginPermission;
import com.radiantminds.roadmap.common.data.entities.permissions.IPermission;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPermissionPersistence;
import com.radiantminds.roadmap.common.extensions.users.UserData;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.permissions.PluginPermissionTargetIds;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginPermissions {
    private final PortfolioPermissionPersistence permissionPersistence;
    private final UserExtension userExtension;

    @Autowired
    public PluginPermissions(PortfolioPermissionPersistence permissionPersistence, UserExtension userExtension) {
        this.permissionPersistence = permissionPersistence;
        this.userExtension = userExtension;
    }

    public boolean check(PluginPermission.Or pluginPermissions) throws SQLException {
        UserData userData = this.userExtension.getActiveUserData();
        Collection<PluginPermission> pluginPermissionsToCheck = pluginPermissions.getWithMorePermissive();
        if (userData.isAdministrator() && pluginPermissionsToCheck.contains((Object)PluginPermission.Admin)) {
            return true;
        }
        Set<String> targetIds = pluginPermissionsToCheck.stream().map(PluginPermissionTargetIds::getTargetId).collect(Collectors.toSet());
        return this.checkPermission(userData, targetIds);
    }

    public boolean check(PluginPermission pluginPermission) throws Exception {
        return this.check(this.or(pluginPermission));
    }

    public boolean checkOr(PluginPermission ... pluginPermissions) throws SQLException {
        return this.check(this.or(pluginPermissions));
    }

    private boolean checkPermission(UserData userData, Collection<String> targetIds) throws SQLException {
        return this.permissionPersistence.testPluginPermissions(targetIds, userData.getUserID(), userData.getGroupIDs());
    }

    public static List<IPermission> getSecuredPermissions(PortfolioPermissionPersistence permissionPersistence, @Nullable UserExtension userExtension, String targetId) throws SQLException {
        List<IPermission> permissions = permissionPersistence.getPermissionsCached("system", targetId);
        if (userExtension != null) {
            permissions = userExtension.removeMissingEntries(permissions);
        }
        return permissions;
    }

    private PluginPermission.Or or(PluginPermission ... pluginPermissions) {
        return new PluginPermission.Or(pluginPermissions);
    }
}

