/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.common;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.common.IDescribable;
import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.common.IReplanningAware;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsServiceHandler;
import com.radiantminds.roadmap.common.rest.services.common.SchedulingRelevantPatchChecker;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
public abstract class BaseOperationsService<TEntityInterface extends IIdentifiable, TRestEntity extends TEntityInterface> {
    private static final Log LOGGER = Log.with(BaseOperationsService.class);
    private final boolean replanningAware;
    private final BaseOperationsServiceHandler<TEntityInterface, TRestEntity> baseOperationHandler;

    protected BaseOperationsService(Class<TRestEntity> restClazz, IEntityPersistence<TEntityInterface> persistence, SecuredInvocationHandlerFactory handlerFactory) {
        this.replanningAware = IReplanningAware.class.isAssignableFrom(restClazz);
        this.baseOperationHandler = handlerFactory.createProxy(BaseOperationsServiceHandler.class, new BaseOperationsServiceHandler.Impl(persistence), persistence);
    }

    protected abstract TRestEntity transform(TEntityInterface var1, boolean var2);

    protected abstract Response update(TRestEntity var1, TEntityInterface var2, boolean var3);

    protected boolean isIncrementingSchedulingVersion(TRestEntity update) {
        return SchedulingRelevantPatchChecker.test(update);
    }

    @GET
    @Path(value="/{id}")
    public Response entryGet(@PathParam(value="id") String id, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="replanning") Boolean replanning) throws Exception {
        return this.baseOperationHandler.entryGet(EntityContext.from(id, expectedPlanVersion), (Boolean)Optional.fromNullable((Object)replanning).or((Object)false), this.replanningAware, new BaseOperationsServiceHandler.TransformEntityFunction<TEntityInterface, TRestEntity>(){

            @Override
            public TRestEntity transform(TEntityInterface entity, boolean includeReplanningData) {
                return BaseOperationsService.this.transform(entity, includeReplanningData);
            }
        });
    }

    @PUT
    @Path(value="{id}")
    public Response entryPut(@PathParam(value="id") String id, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, TRestEntity restEntity) throws Exception {
        return this.baseOperationHandler.update(EntityContext.from(id, restEntity.getVersion(), expectedPlanVersion, clientId), restEntity, true, new BaseOperationsServiceHandler.UpdateEntityFunction<TEntityInterface, TRestEntity>(){

            @Override
            public Response apply(TRestEntity source, TEntityInterface target, boolean allowNull) {
                return BaseOperationsService.this.update(source, target, allowNull);
            }
        }, new BaseOperationsServiceHandler.IncrementSchedulingVersionFunction<TRestEntity>(){

            @Override
            public boolean apply(TRestEntity update) {
                return BaseOperationsService.this.isIncrementingSchedulingVersion(update);
            }
        });
    }

    @POST
    @Path(value="{id}/patch")
    public Response entryPatchWithPost(@PathParam(value="id") String id, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, TRestEntity restEntity) throws Exception {
        return this.baseOperationHandler.update(EntityContext.from(id, restEntity.getVersion(), expectedPlanVersion, clientId), restEntity, false, new BaseOperationsServiceHandler.UpdateEntityFunction<TEntityInterface, TRestEntity>(){

            @Override
            public Response apply(TRestEntity source, TEntityInterface target, boolean allowNull) {
                return BaseOperationsService.this.update(source, target, allowNull);
            }
        }, new BaseOperationsServiceHandler.IncrementSchedulingVersionFunction<TRestEntity>(){

            @Override
            public boolean apply(TRestEntity update) {
                return BaseOperationsService.this.isIncrementingSchedulingVersion(update);
            }
        });
    }

    @DELETE
    @Path(value="{id}")
    public Response entryDelete(@PathParam(value="id") String id, @QueryParam(value="version") Long version, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId) throws Exception {
        return this.baseOperationHandler.entryDelete(EntityContext.from(id, version, expectedPlanVersion, clientId));
    }

    protected Response updateCommons(TRestEntity source, TEntityInterface target, boolean allowNull) {
        if (source instanceof IDescribable) {
            IDescribable describableSource = (IDescribable)source;
            IDescribable describableTarget = (IDescribable)target;
            if (allowNull || describableSource.getTitle() != null) {
                describableTarget.setTitle(describableSource.getTitle());
            }
            if (allowNull || describableSource.getDetails() != null) {
                describableTarget.setDetails(describableSource.getDetails());
            }
        }
        return null;
    }
}

