/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.exportimport;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PlanExportCache;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PlanExporter;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PlanXml;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PortProgress;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlExportablePersistenceIndex;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.RestKey;
import com.radiantminds.roadmap.common.rest.utils.async.LongRunningService;
import com.radiantminds.roadmap.common.rest.utils.async.LongRunningServiceTask;
import com.radiantminds.roadmap.common.utils.meta.MetaDataUtils;
import javax.ws.rs.core.Response;

public interface ExportServiceHandler {
    @AuthorizedPlanReadAccess(entityNeeded=true)
    public Response exportPlan(EntityContext<IPlan> var1, Boolean var2, Boolean var3) throws Exception;

    public static class Impl
    implements ExportServiceHandler {
        private final PlanExporter planExporter;
        private final LongRunningService longRunningService;

        public Impl(XmlExportablePersistenceIndex index, ActiveObjectsUtilities activeObjectsUtilities, LongRunningService longRunningService, MetaDataUtils metaDataUtils) {
            this.longRunningService = longRunningService;
            this.planExporter = new PlanExporter(activeObjectsUtilities, index, metaDataUtils);
        }

        @Override
        public Response exportPlan(final EntityContext<IPlan> entityContext, final Boolean anonymise, final Boolean excludeLinks) throws Exception {
            return this.longRunningService.service(new LongRunningServiceTask(){
                private PortProgress progress = new PortProgress();

                @Override
                public Response execute() throws Exception {
                    String xml = planExporter.export(entityContext.getEntityId(), this.progress, Boolean.TRUE.equals(anonymise), Boolean.TRUE.equals(excludeLinks));
                    PlanXml planXml = new PlanXml(entityContext.getEntityId(), ((IPlan)entityContext.getEntity()).getTitle(), xml);
                    String key = PlanExportCache.store(planXml);
                    return ResponseBuilder.ok(new RestKey(key));
                }

                @Override
                public Object getStatusEntity() {
                    return this.progress;
                }
            });
        }
    }
}

