/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems;

import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.entities.workitems.bulk.RestWorkItemBulk;
import com.radiantminds.roadmap.common.rest.services.workitems.WorkItemBulkAddTask;
import com.radiantminds.roadmap.common.rest.services.workitems.WorkItemUtils;
import com.radiantminds.roadmap.common.rest.utils.async.LongRunningService;
import javax.ws.rs.core.Response;

public interface PlanWorkItemBulkServiceHandler {
    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response addWorkItemsInBulk(EntityContext<IPlan> var1, RestWorkItemBulk var2) throws Exception;

    public static class Impl
    implements PlanWorkItemBulkServiceHandler {
        private final LongRunningService longRunningService;
        private final PortfolioWorkItemPersistence workItemPersistence;
        private final PortfolioToJiraSyncExtension portfolioToJiraSyncExtension;
        private final WorkItemUtils workItemPersister;

        public Impl(PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension, LongRunningService longRunningService) {
            this.workItemPersistence = workItemPersistence;
            this.portfolioToJiraSyncExtension = portfolioToJiraSyncExtension;
            this.longRunningService = longRunningService;
            this.workItemPersister = new WorkItemUtils(this.workItemPersistence, estimatePersistence, extensionLinkPersistence);
        }

        @Override
        public Response addWorkItemsInBulk(EntityContext<IPlan> entityContext, RestWorkItemBulk bulk) throws Exception {
            return this.longRunningService.service(WorkItemBulkAddTask.create(entityContext, bulk, this.workItemPersister, this.workItemPersistence, this.portfolioToJiraSyncExtension));
        }
    }
}

