/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.teamresource;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.people.ISprint;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.people.PlanningMode;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.assignment.RestTeamResourceAssignment;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.services.common.Operation;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.WorkItemConstraintChecker;
import com.radiantminds.roadmap.common.rest.services.workitems.teamresource.AssignmentType;
import java.util.ArrayList;
import java.util.Set;
import javax.ws.rs.core.Response;

public class TeamResourceOperation
extends Operation {
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final PortfolioTeamPersistence teamPersistence;
    private final RestTeamResourceAssignment assignment;
    private final DataMode dataMode;
    private final AssignmentType assignmentType;
    private final WorkItemConstraintChecker workItemConstraintChecker;

    public TeamResourceOperation(PortfolioWorkItemPersistence workItemPersistence, PortfolioTeamPersistence teamPersistence, RestTeamResourceAssignment assignment, DataMode dataMode, AssignmentType assignmentType) {
        this.workItemPersistence = workItemPersistence;
        this.teamPersistence = teamPersistence;
        this.assignment = assignment;
        this.dataMode = dataMode;
        this.assignmentType = assignmentType;
        this.workItemConstraintChecker = new WorkItemConstraintChecker(workItemPersistence);
    }

    @Override
    public Response preOperationChecks() throws Exception {
        boolean valid;
        if (this.assignment == null) {
            return ResponseBuilder.badRequest(RestMessaging.error("no assignment supplied"));
        }
        if (this.assignment.getTeamId() != null && !this.teamPersistence.exists(this.assignment.getTeamId())) {
            return ResponseBuilder.badRequest(RestMessaging.error("invalid-team-assignment"));
        }
        if (this.assignmentType.assignSprint()) {
            if (!this.workItemPersistence.validateSprintAssignment(this.assignment.getTeamId(), this.assignment.getSprintId())) {
                return ResponseBuilder.badRequest(RestMessaging.error("invalid-sprint-assignment"));
            }
            if (this.assignment.getSprintId() != null && this.isKanbanTeam(this.assignment.getTeamId())) {
                return ResponseBuilder.badRequest(RestMessaging.error("kanban-sprint-assignment"));
            }
        }
        if (this.assignmentType.assignResources() && !(valid = this.workItemPersistence.validateResourceAssignments(this.assignment.getTeamId(), this.assignment.getResourceIds()))) {
            return ResponseBuilder.badRequest(RestMessaging.error("invalid-team-assignment"));
        }
        return null;
    }

    @Override
    public void preItemCheck(String workItemId) throws Exception {
        String constraintCheck = this.workItemConstraintChecker.isAssignable(workItemId);
        if (constraintCheck != null) {
            throw new Exception("type-not-assignable");
        }
        if (!this.assignmentType.assignEverything()) {
            this.checkPartialAssignment(workItemId);
        }
    }

    private void checkPartialAssignment(String workItemId) throws Exception {
        ArrayList<String> newResourceIds;
        Optional<ISprint> currentSprint = ((IWorkItem)this.workItemPersistence.get(workItemId)).getSprint();
        String currentSprintId = currentSprint.isPresent() ? ((ISprint)currentSprint.get()).getId() : null;
        Set<String> currentResourceIds = this.workItemPersistence.getResourceAssignmentsForWorkItem(workItemId, this.dataMode == DataMode.Replanning);
        String newSprintId = this.assignmentType.assignSprint() ? this.assignment.getSprintId() : currentSprintId;
        if (this.assignmentType.assignResources()) {
            newResourceIds = this.assignment.getResourceIds();
        } else {
            ArrayList<String> arrayList = newResourceIds = currentResourceIds != null ? new ArrayList<String>(currentResourceIds) : null;
        }
        if (!this.workItemPersistence.validateSprintAssignment(this.assignment.getTeamId(), newSprintId)) {
            throw new Exception("invalid-sprint-assignment");
        }
        if (!this.workItemPersistence.validateResourceAssignments(this.assignment.getTeamId(), newResourceIds)) {
            throw new Exception("invalid-team-assignment");
        }
    }

    @Override
    public void performOperation(String workItemId) throws Exception {
        boolean replanning;
        boolean bl = replanning = this.dataMode == DataMode.Replanning;
        if (this.assignmentType.assignEverything()) {
            this.workItemPersistence.setTeamSprintResourceAssignment(workItemId, this.assignment.getTeamId(), this.assignment.getSprintId(), this.assignment.getResourceIds(), replanning);
        } else if (this.assignmentType.assignSprint()) {
            this.workItemPersistence.setSprintAssignment(workItemId, this.assignment.getTeamId(), this.assignment.getSprintId(), replanning);
        } else if (this.assignmentType.assignResources()) {
            this.workItemPersistence.setResourceAssignments(workItemId, this.assignment.getTeamId(), this.assignment.getResourceIds(), replanning);
        }
    }

    private boolean isKanbanTeam(String teamId) throws PersistenceException {
        return teamId != null && this.teamPersistence.get(teamId) != null && ((ITeam)this.teamPersistence.get(teamId)).getPlanningMode() == PlanningMode.Kanban;
    }
}

