/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.FullContentSchedulingPlan;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSolutionPersistence;
import com.radiantminds.roadmap.common.extensions.analytics.AnalyticsExtension;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.extensions.threading.ThreadPoolExtension;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolution;
import com.radiantminds.roadmap.common.scheduling.Calculation;
import com.radiantminds.roadmap.common.scheduling.CalculationExecutor;
import com.radiantminds.roadmap.common.scheduling.CalculationListener;
import com.radiantminds.roadmap.common.scheduling.CalculationVitalityHandler;
import com.radiantminds.roadmap.common.scheduling.DatabaseCalculation;
import com.radiantminds.roadmap.common.scheduling.LocalCalculationExecutor;
import com.radiantminds.roadmap.common.scheduling.PluginCalculationProcessProvider;
import com.radiantminds.roadmap.common.scheduling.entities.SchedulingPlanFactory;
import com.radiantminds.roadmap.common.utils.meta.MetaDataUtils;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Scheduling {
    private static final Log LOGGER = Log.with(Scheduling.class);
    private final Object lock = new Object();
    private final CalculationExecutor calculationExecutor;
    private final SchedulingPlanFactory schedulingPlanFactory;
    private final CalculationVitalityHandler vitalityHandler;
    private final PluginCalculationProcessProvider calculationProcessProvider;
    private final AnalyticsExtension analyticsExtension;
    private final PortfolioSolutionPersistence solutionPersistence;
    private final Cache<String, Calculation> calculationCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(12L, TimeUnit.HOURS).build();

    @Autowired
    public Scheduling(ThreadPoolExtension threadPoolExtension, SchedulingPlanFactory schedulingPlanFactory, FeatureExtension featureExtension, AnalyticsExtension analyticsExtension, CalculationVitalityHandler vitalityHandler, MetaDataUtils metaDataUtils, ActiveObjectsUtilities activeObjectsUtilities, PortfolioSolutionPersistence solutionPersistence) {
        this.analyticsExtension = analyticsExtension;
        this.solutionPersistence = solutionPersistence;
        this.calculationExecutor = new LocalCalculationExecutor(threadPoolExtension);
        this.schedulingPlanFactory = schedulingPlanFactory;
        this.vitalityHandler = vitalityHandler;
        this.calculationProcessProvider = new PluginCalculationProcessProvider(featureExtension, metaDataUtils, activeObjectsUtilities);
    }

    public Optional<Calculation> getSolutionForPlan(String planId) {
        return this.getSpecificSolutionForPlan(planId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Calculation> getSpecificSolutionForPlan(String planId, Long schedulingVersion) {
        Optional inDb;
        Calculation inMemory;
        Object object = this.lock;
        synchronized (object) {
            inMemory = (Calculation)this.calculationCache.getIfPresent((Object)planId);
        }
        if (Scheduling.isCalculationValid(inMemory, schedulingVersion)) {
            return Optional.fromNullable((Object)inMemory);
        }
        try {
            inDb = this.solutionPersistence.get(planId, schedulingVersion);
        }
        catch (SQLException ex) {
            LOGGER.error("Failed to query solution persistence.", new Object[0]);
            LOGGER.exception(ex, Log.LogLevel.ERROR);
            inDb = Optional.absent();
        }
        if (inDb.isPresent()) {
            LOGGER.info("Found solution in database. Storing to cache.", new Object[0]);
            Object object2 = this.lock;
            synchronized (object2) {
                Calculation fromCache = (Calculation)this.calculationCache.getIfPresent((Object)planId);
                if (Scheduling.isCalculationValid(fromCache, schedulingVersion)) {
                    return Optional.of((Object)fromCache);
                }
                DatabaseCalculation calculation = new DatabaseCalculation((RestSchedulingSolution)inDb.get());
                this.calculationCache.put((Object)planId, (Object)calculation);
                return Optional.of((Object)calculation);
            }
        }
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSolution(String planId) throws Exception {
        FullContentSchedulingPlan plan = this.schedulingPlanFactory.create(planId);
        Optional<Calculation> previous = this.getSpecificSolutionForPlan(planId, plan.getSchedulingVersion());
        if (!previous.isPresent()) {
            Calculation calculation = new Calculation(this.calculationExecutor, this.calculationProcessProvider, this.vitalityHandler, this.analyticsExtension, plan);
            Object object = this.lock;
            synchronized (object) {
                Calculation fromCache = (Calculation)this.calculationCache.getIfPresent((Object)planId);
                if (Scheduling.isCalculationValid(fromCache, plan.getSchedulingVersion())) {
                    return;
                }
                if (fromCache != null && !fromCache.isCancelled()) {
                    fromCache.cancel();
                }
                this.calculationCache.put((Object)planId, (Object)calculation);
            }
            calculation.calculate(new CalculationListener(){

                @Override
                public void completedWithResult(String planId, RestSchedulingSolution solution) {
                    try {
                        Scheduling.this.solutionPersistence.store(planId, solution);
                    }
                    catch (SQLException ex) {
                        LOGGER.warn("Failed to persist solution to database.", new Object[0]);
                        LOGGER.exception(ex, Log.LogLevel.WARN);
                    }
                }
            });
        }
    }

    private static boolean isCalculationValid(Calculation calculation, Long schedulingVersion) {
        return calculation != null && calculation.getSchedulingVersion() != null && !calculation.isCancelled() && (schedulingVersion == null || schedulingVersion <= calculation.getSchedulingVersion());
    }

    public void clearAllResults() {
        this.calculationCache.invalidateAll();
    }
}

