/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CommonUtils {
    private CommonUtils() {
    }

    public static <T extends IIdentifiable> Map<String, T> createIdMap(Collection<T> identifiables) {
        Preconditions.checkNotNull(identifiables, (Object)"set of identifiables must not be null");
        HashMap map = Maps.newHashMapWithExpectedSize((int)identifiables.size());
        for (IIdentifiable identifiable : identifiables) {
            String id = identifiable.getId();
            map.put(id, identifiable);
        }
        return map;
    }

    public static Map<String, IRelease> createReleaseMap(Collection<IStream> streams) {
        HashMap releasesMap = Maps.newHashMap();
        for (IStream stream : streams) {
            for (IRelease release : stream.getReleases()) {
                releasesMap.put(release.getId(), release);
            }
            releasesMap.put(stream.getLaterRelease().getId(), stream.getLaterRelease());
        }
        return releasesMap;
    }
}

