/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.lastsplits;

import org.javasimon.Simon;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.callback.CallbackSkeleton;
import org.javasimon.callback.lastsplits.LastSplits;
import org.javasimon.callback.logging.LogTemplate;
import org.javasimon.callback.logging.LogTemplates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastSplitsCallback
extends CallbackSkeleton {
    public static final String ATTR_NAME_LAST_SPLITS = "lastSplits";
    private final int capacity;
    private boolean logEnabled = false;
    private final LogTemplate<Split> enabledStopwatchLogTemplate = LogTemplates.toSLF4J(this.getClass().getName(), "debug");

    public LastSplitsCallback() {
        this.capacity = 10;
    }

    public LastSplitsCallback(int capacity) {
        this.capacity = capacity;
    }

    private LastSplits getLastSplits(Stopwatch stopwatch) {
        return (LastSplits)stopwatch.getAttribute(ATTR_NAME_LAST_SPLITS);
    }

    @Override
    public void onSimonCreated(Simon simon) {
        if (simon instanceof Stopwatch) {
            Stopwatch stopwatch = (Stopwatch)simon;
            LastSplits lastSplits = new LastSplits(this.capacity);
            lastSplits.setLogTemplate(this.createLogTemplate(stopwatch));
            stopwatch.setAttribute(ATTR_NAME_LAST_SPLITS, lastSplits);
        }
    }

    @Override
    public void onStopwatchStop(Split split, StopwatchSample sample) {
        LastSplits lastSplits = this.getLastSplits(split.getStopwatch());
        lastSplits.add(split);
        lastSplits.log(split);
    }

    @Override
    public void onStopwatchAdd(Stopwatch stopwatch, Split split, StopwatchSample sample) {
        LastSplits lastSplits = this.getLastSplits(stopwatch);
        lastSplits.add(split);
        lastSplits.log(split);
    }

    @Override
    public void onSimonReset(Simon simon) {
        if (simon instanceof Stopwatch) {
            this.getLastSplits((Stopwatch)simon).clear();
        }
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    protected LogTemplate<Split> createLogTemplate(Stopwatch stopwatch) {
        LogTemplate<Split> logTemplate = this.logEnabled ? LogTemplates.everyNSplits(this.enabledStopwatchLogTemplate, this.capacity) : LogTemplates.disabled();
        return logTemplate;
    }
}

