/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

abstract class BaseScrumSlotsDefinition
implements WorkSlotsDefinition {
    static final int DAYS_PER_WEEK = 7;
    final String groupId;
    private final TimeStepPresenceFunction timeStepPresenceFunction;
    private int defaultPresence;

    BaseScrumSlotsDefinition(int weeks, String groupId, TimeStepPresenceFunction timeStepPresenceFunction) {
        this.defaultPresence = timeStepPresenceFunction.getWeeklyWorkDays() * weeks;
        this.groupId = groupId;
        this.timeStepPresenceFunction = timeStepPresenceFunction;
    }

    @Override
    public boolean isWorkSlotStrict() {
        return true;
    }

    @Override
    public IWorkSlot getNextWorkSlotWithFullPresence(int timeStep) {
        IWorkSlot workSlot = this.getNextValidWorkSlotForReleaseTime(timeStep);
        while (this.timeStepPresenceFunction.getPresenceSum(workSlot) < this.defaultPresence || workSlot.isRestricted()) {
            workSlot = this.getNextWorkSlot(workSlot);
        }
        return workSlot;
    }

    @Override
    public List<IWorkSlot> getWorkSlotsBetween(int startTime, int endTime) {
        ArrayList slots = Lists.newArrayList();
        IWorkSlot slot = this.getNextValidWorkSlotForReleaseTime(startTime);
        while (slot.getEnd() <= endTime) {
            slots.add(slot);
            slot = this.getNextWorkSlot(slot);
        }
        return slots;
    }
}

