/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.rm.common.bridges.jira.lucene.JiraLuceneQueryUtilitiesProxy;
import com.atlassian.rm.common.bridges.jira.search.SearchProviderFactoryBridge;
import com.atlassian.rm.common.bridges.jira.search.SearchProviderFactoryBridgeProxy;
import com.atlassian.rm.common.bridges.lucene.IndexSearcher;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.IssueHierarchyResult;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.LuceneHierarchyResult;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LuceneJiraIssueAccessor {
    private final SearchProviderFactoryBridgeProxy searchProviderFactoryBridgeProxy;
    private final CustomFields customFields;
    private final StatusManager statusManager;
    private final ApplicationProperties applicationProperties;
    private final FieldManager fieldManager;
    private final JiraLuceneQueryUtilitiesProxy jiraLuceneQueryUtilities;

    @Autowired
    public LuceneJiraIssueAccessor(SearchProviderFactoryBridgeProxy searchProviderFactoryBridgeProxy, CustomFields customFields, StatusManager statusManager, ApplicationProperties applicationProperties, FieldManager fieldManager, JiraLuceneQueryUtilitiesProxy jiraLuceneQueryUtilities) {
        this.searchProviderFactoryBridgeProxy = searchProviderFactoryBridgeProxy;
        this.customFields = customFields;
        this.statusManager = statusManager;
        this.applicationProperties = applicationProperties;
        this.fieldManager = fieldManager;
        this.jiraLuceneQueryUtilities = jiraLuceneQueryUtilities;
    }

    IssueHierarchyResult retrieveFullHierarchy(Set<String> jpoKeys) throws Exception {
        IndexSearcher indexSearcher = ((SearchProviderFactoryBridge)this.searchProviderFactoryBridgeProxy.get()).getIssueIndexSearcher();
        return LuceneHierarchyResult.extract(indexSearcher, this.fieldManager, this.jiraLuceneQueryUtilities, this.customFields, this.statusManager, this.applicationProperties, jpoKeys);
    }
}

