/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.customfields.searchers;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SingleValueCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.pocketknife.api.customfields.searchers.clausevalidator.AbstractClauseValidator;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractPluginCustomFieldSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final CustomFieldInputHelper customFieldInputHelper;
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;

    public AbstractPluginCustomFieldSearcher(FieldVisibilityManager fieldVisibilityManager, JqlOperandResolver jqlOperandResolver, CustomFieldInputHelper customFieldInputHelper) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.customFieldInputHelper = customFieldInputHelper;
    }

    protected abstract IndexValueConverter getNewIndexValueConverter();

    protected abstract FieldIndexer getNewCustomFieldIndexer(FieldVisibilityManager var1, CustomField var2);

    protected abstract CustomFieldRenderer getNewCustomFieldSearchRenderer(ClauseNames var1, CustomFieldSearcherModuleDescriptor var2, CustomField var3, CustomFieldValueProvider var4, FieldVisibilityManager var5);

    protected abstract SearchInputTransformer getNewSearchInputTransformer(CustomField var1, CustomFieldInputHelper var2);

    protected abstract AbstractClauseValidator getNewClauseValidator();

    protected abstract ClauseQueryFactory getNewClauseQueryFactory(CustomField var1, JqlOperandResolver var2, IndexValueConverter var3);

    protected abstract SimpleCustomFieldSearcherClauseHandler getNewCustomFieldSearcherClauseHandler(AbstractClauseValidator var1, ClauseQueryFactory var2);

    protected abstract JiraDataType getDataType();

    public void init(CustomField field) {
        ClauseNames names = field.getClauseNames();
        IndexValueConverter indexValueConverter = this.getNewIndexValueConverter();
        FieldIndexer indexer = this.getNewCustomFieldIndexer(this.fieldVisibilityManager, field);
        SingleValueCustomFieldValueProvider customFieldValueProvider = new SingleValueCustomFieldValueProvider();
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = this.getNewCustomFieldSearchRenderer(names, this.getDescriptor(), field, (CustomFieldValueProvider)customFieldValueProvider, this.fieldVisibilityManager);
        this.searchInputTransformer = this.getNewSearchInputTransformer(field, this.customFieldInputHelper);
        ClauseQueryFactory clauseQueryFactory = this.getNewClauseQueryFactory(field, this.jqlOperandResolver, indexValueConverter);
        this.customFieldSearcherClauseHandler = this.getNewCustomFieldSearcherClauseHandler(this.getNewClauseValidator(), clauseQueryFactory);
    }

    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }
}

