/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.api;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.BridgeManager;
import com.atlassian.rm.common.bridges.api.FeatureAccessor;
import com.atlassian.rm.common.bridges.api.NoBridgeAvailableException;
import com.atlassian.rm.common.bridges.api.Version;
import com.atlassian.rm.common.bridges.api.VersionProxy;
import com.google.common.base.Optional;
import java.util.List;

public class AbstractVersionlessBridgeProxy<T>
implements VersionProxy<T> {
    private static final Log LOGGER = Log.with(AbstractVersionlessBridgeProxy.class);
    private final BridgeManager<T> bridgeManager;
    private final Class<T> bridgeClazz;

    protected AbstractVersionlessBridgeProxy(Class<T> bridgeClazz, List<T> beans, FeatureAccessor featureAccessor) {
        this.bridgeClazz = bridgeClazz;
        this.bridgeManager = new BridgeManager<T>(beans, (Optional<FeatureAccessor>)Optional.of((Object)featureAccessor));
    }

    @Override
    public T get() {
        Optional<T> supportedBridge = this.bridgeManager.getSupportedBridge(new Version("0.0.0"));
        if (supportedBridge.isPresent()) {
            Object bridge = supportedBridge.get();
            LOGGER.debug(String.format("Bridge implementation %s chosen.", bridge.getClass()), new Object[0]);
            return (T)bridge;
        }
        LOGGER.warn(String.format("No bridge implementation for %s available.", this.bridgeClazz.toString()), new Object[0]);
        throw new NoBridgeAvailableException(new Version("0.0.0"), this.bridgeClazz);
    }
}

