/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.Field;

final class FieldConfigurationBuilder
implements Field.Configuration.Builder {
    private boolean analyzed = true;
    private boolean omitNorms = false;
    private boolean stored = true;
    private boolean sortable = false;
    private boolean multiValued = false;

    FieldConfigurationBuilder() {
    }

    @Override
    public Field.Configuration.Builder set(Field.Configuration configuration) {
        return this.setAnalyzed(configuration.isAnalyzed()).setOmitNorms(configuration.isOmitNorms()).setStored(configuration.isStored()).setSortable(configuration.isSortable()).setMultiValued(configuration.isMultiValued());
    }

    @Override
    public Field.Configuration.Builder setAnalyzed(boolean analyzed) {
        this.analyzed = analyzed;
        return this;
    }

    @Override
    public Field.Configuration.Builder setOmitNorms(boolean omitNorms) {
        this.omitNorms = omitNorms;
        return this;
    }

    @Override
    public Field.Configuration.Builder setStored(boolean stored) {
        this.stored = stored;
        return this;
    }

    @Override
    public Field.Configuration.Builder setSortable(boolean sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public Field.Configuration.Builder setMultiValued(boolean multiValued) {
        this.multiValued = multiValued;
        return this;
    }

    @Override
    public Field.Configuration build() {
        return new DefaultConfiguration(this);
    }

    static final class DefaultConfiguration
    implements Field.Configuration {
        private final boolean analyzed;
        private final boolean omitNorms;
        private final boolean stored;
        private final boolean sortable;
        private final boolean multiValued;

        private DefaultConfiguration(FieldConfigurationBuilder builder) {
            this.analyzed = builder.analyzed;
            this.omitNorms = builder.omitNorms;
            this.stored = builder.stored;
            this.sortable = builder.sortable;
            this.multiValued = builder.multiValued;
        }

        @Override
        public boolean isAnalyzed() {
            return this.analyzed;
        }

        @Override
        public boolean isOmitNorms() {
            return this.omitNorms;
        }

        @Override
        public boolean isStored() {
            return this.stored;
        }

        @Override
        public boolean isSortable() {
            return this.sortable;
        }

        @Override
        public boolean isMultiValued() {
            return this.multiValued;
        }
    }
}

