/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.pkqdsl.legacy;

import com.atlassian.rm.common.pkqdsl.legacy.MemoizingResettingReference;
import com.atlassian.rm.common.pkqdsl.legacy.SchemaProvider;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.pkqdsl.legacy.DefaultSchemaProvider")
public class DefaultSchemaProvider
implements SchemaProvider {
    private static final String SCHEMA_NAME_KEY = "TABLE_SCHEM";
    private static final String TABLE_NAME_KEY = "TABLE_NAME";
    private static final String COLUMN_NAME_KEY = "COLUMN_NAME";
    private final MemoizingResettingReference<Connection, Map<String, String>> tableToSchemaRef = new MemoizingResettingReference<Connection, Map<String, String>>(this.tableToSchemaFunction());
    private final MemoizingResettingReference<Connection, Map<NameKey, String>> tableColumnNamesRef = new MemoizingResettingReference<Connection, Map<NameKey, String>>(this.tableColumnsNamesFunction());

    @Override
    public void prime(Connection connection) {
        this.tableToSchemaRef.get(connection);
        this.tableColumnNamesRef.get(connection);
    }

    @Override
    public void reprime(Connection connection) {
        this.tableToSchemaRef.reset();
        this.tableColumnNamesRef.reset();
        this.prime(connection);
    }

    @Override
    public String getSchema(@Nonnull String logicalTableName) {
        Preconditions.checkArgument((!StringUtils.isEmpty(logicalTableName) ? 1 : 0) != 0, (Object)"Table name is required");
        Map<String, String> tableToSchema = this.tableSchemaRef();
        String tableName = tableToSchema.get(logicalTableName.toUpperCase());
        if (tableName != null) {
            return tableName;
        }
        throw new IllegalArgumentException(String.format("Not able to find table %s", logicalTableName));
    }

    @Override
    public String getTableName(@Nonnull String logicalTableName) {
        Preconditions.checkArgument((!StringUtils.isEmpty(logicalTableName) ? 1 : 0) != 0, (Object)"Table name is required");
        Map<NameKey, String> tableColumnNames = this.tableColumnNamesRef();
        NameKey key = new NameKey(logicalTableName);
        return tableColumnNames.get(key);
    }

    @Override
    public String getColumnName(@Nonnull String logicalTableName, @Nonnull String logicalColumnName) {
        Preconditions.checkArgument((!StringUtils.isEmpty(logicalTableName) ? 1 : 0) != 0, (Object)"Table name is required");
        Preconditions.checkArgument((!StringUtils.isEmpty(logicalColumnName) ? 1 : 0) != 0, (Object)"Column name is required");
        Map<NameKey, String> tableColumnNames = this.tableColumnNamesRef();
        NameKey key = new NameKey(logicalTableName, logicalColumnName);
        return tableColumnNames.get(key);
    }

    private Map<String, String> tableSchemaRef() {
        try {
            return this.tableToSchemaRef.getMemoizedValue();
        }
        catch (MemoizingResettingReference.MemoizedValueNotPresentException e) {
            throw new UnprimedSchemaProviderException(e);
        }
    }

    private Map<NameKey, String> tableColumnNamesRef() {
        try {
            return this.tableColumnNamesRef.getMemoizedValue();
        }
        catch (MemoizingResettingReference.MemoizedValueNotPresentException e) {
            throw new UnprimedSchemaProviderException(e);
        }
    }

    private Function<Connection, Map<String, String>> tableToSchemaFunction() {
        return new Function<Connection, Map<String, String>>(){

            public Map<String, String> apply(Connection connection) {
                return DefaultSchemaProvider.this.tablesToSchema(connection);
            }
        };
    }

    private Map<String, String> tablesToSchema(Connection connection) {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            try (ResultSet resultSet = connection.getMetaData().getTables(null, null, null, null);){
                while (resultSet.next()) {
                    String tableName = resultSet.getString(TABLE_NAME_KEY);
                    String tableSchema = resultSet.getString(SCHEMA_NAME_KEY);
                    String schemaName = "";
                    if (StringUtils.isNotEmpty(tableSchema)) {
                        schemaName = tableSchema;
                    }
                    result.put(tableName.toUpperCase(), schemaName);
                }
            }
            return result;
        }
        catch (SQLException sqlEx) {
            throw new RuntimeException("Unable to enquire table names available in the system", sqlEx);
        }
    }

    private Function<Connection, Map<NameKey, String>> tableColumnsNamesFunction() {
        return new Function<Connection, Map<NameKey, String>>(){

            public Map<NameKey, String> apply(Connection connection) {
                return DefaultSchemaProvider.this.tableColumnNames(connection);
            }
        };
    }

    private Map<NameKey, String> tableColumnNames(Connection connection) {
        try {
            HashMap<NameKey, String> result = new HashMap<NameKey, String>();
            DatabaseMetaData metaData = connection.getMetaData();
            this.findTableNames(metaData, result);
            this.findColumnNames(metaData, result);
            return result;
        }
        catch (SQLException sqlEx) {
            throw new RuntimeException("Unable to enquire table names available in the system", sqlEx);
        }
    }

    private void findColumnNames(DatabaseMetaData metaData, Map<NameKey, String> result) throws SQLException {
        try (ResultSet columnResultSet = metaData.getColumns(null, null, null, null);){
            while (columnResultSet.next()) {
                String tableName = columnResultSet.getString(TABLE_NAME_KEY);
                String columnName = columnResultSet.getString(COLUMN_NAME_KEY);
                result.put(new NameKey(tableName, columnName), columnName);
            }
        }
    }

    private void findTableNames(DatabaseMetaData metaData, Map<NameKey, String> result) throws SQLException {
        try (ResultSet resultSet = metaData.getTables(null, null, null, null);){
            while (resultSet.next()) {
                String tableName = resultSet.getString(TABLE_NAME_KEY);
                result.put(new NameKey(tableName), tableName);
            }
        }
    }

    private static class NameKey {
        private final String tableName;
        private final String columnName;

        private NameKey(@Nonnull String tableName) {
            this(tableName, (String)null);
        }

        private NameKey(@Nonnull String tableName, String columnName) {
            this.tableName = ((String)Preconditions.checkNotNull((Object)tableName)).toUpperCase();
            this.columnName = columnName == null ? null : columnName.toUpperCase();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            NameKey other = (NameKey)obj;
            return this.tableName.equals(other.tableName) && (this.columnName == null ? other.columnName == null : this.columnName.equals(other.columnName));
        }

        public int hashCode() {
            int result = this.tableName.hashCode();
            result = 31 * result + (this.columnName != null ? this.columnName.hashCode() : 0);
            return result;
        }
    }

    static class UnprimedSchemaProviderException
    extends RuntimeException {
        public UnprimedSchemaProviderException(Throwable cause) {
            super("A call to SchemaProvider.prime(connection) MUST be made before schema information can be consumed.\nThis can occur if you use SchemaProviderAccessor / EnhancedRelationalPathBase in a static context before the database is available.\nRemember the database may not be available during code class initialisation. \nAvoid eager static initialisation when using SchemaProviderAccessor / EnhancedRelationalPathBase to avoid this problem \n", cause);
        }
    }
}

