/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.analysis;

import com.atlassian.rm.jpo.scheduling.roadmap.analysis.ActivitySetWaitingFunctionCalculator;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.BoundDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.EligibleWorkTimeLine;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IBoundedDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IEligibleWorkTimeLine;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IEligibleWorkTimeLineCalculator;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.UnstructuredItemWaitingFunctionCalculator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.UnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IRoadmapSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class EligibleWorkTimeLineCalculator
implements IEligibleWorkTimeLineCalculator {
    private final ActivitySetWaitingFunctionCalculator activitySetWaitiningCalculator = new ActivitySetWaitingFunctionCalculator();
    private final UnstructuredItemWaitingFunctionCalculator itemWaitingCalculator = new UnstructuredItemWaitingFunctionCalculator();

    EligibleWorkTimeLineCalculator() {
    }

    @Override
    public IEligibleWorkTimeLine calculateEligibleWorkTimeLine(IRoadmapProblem problem, IRoadmapSchedule schedule) {
        HashMap restrictedMap = Maps.newHashMap();
        Set<IActivitySetSchedule> activitySetSchedules = schedule.getActivitySetSchedules();
        for (IActivitySetSchedule activitySetSchedule : activitySetSchedules) {
            EligibleWorkTimeLineCalculator.mergeWaitingFunctions(this.activitySetWaitiningCalculator.getWaitingFunctions(activitySetSchedule), restrictedMap, activitySetSchedule.getActivitySet().getAssignmentRestriction().getResourcePools());
        }
        Set<IUnstructuredItemSchedule> splitSchedules = schedule.getEpisodeWiseUnstructuredItemSchedules();
        Map<String, Set<IUnstructuredItemSchedule>> groupedItemSchedules = EligibleWorkTimeLineCalculator.createGroupedItemSchedules(splitSchedules);
        Set<IUnstructuredItemSchedule> mergedSchedules = EligibleWorkTimeLineCalculator.mergeUnstructuredSchedules(groupedItemSchedules.values());
        BiMap<String, IProcessingItem> idToProcessingItemMap = RmIdentifiableUtils.createIdMap(problem.getBacklog().getProcessingItems());
        for (IUnstructuredItemSchedule itemSchedule : mergedSchedules) {
            EligibleWorkTimeLineCalculator.mergeWaitingFunctions(this.itemWaitingCalculator.getWaitingFunctions(itemSchedule, problem.getProcessingDefinition()), restrictedMap, ((IProcessingItem)idToProcessingItemMap.get(itemSchedule.getId())).getAssignmentRestriction().getResourcePools());
        }
        EligibleWorkTimeLine waitingWorkTimeLine = new EligibleWorkTimeLine(restrictedMap, schedule.getEnd());
        return waitingWorkTimeLine;
    }

    private static Set<IUnstructuredItemSchedule> mergeUnstructuredSchedules(Collection<Set<IUnstructuredItemSchedule>> scheduleGroups) {
        HashSet merged = Sets.newHashSetWithExpectedSize((int)scheduleGroups.size());
        for (Set<IUnstructuredItemSchedule> scheduleGroup : scheduleGroups) {
            if (scheduleGroup.size() == 1) {
                merged.add(scheduleGroup.iterator().next());
                continue;
            }
            IUnstructuredItemSchedule schedule = (IUnstructuredItemSchedule)UnstructuredItemSchedule.tryCreateFromPartialSchedules(Sets.newHashSet(), scheduleGroup, true).get();
            merged.add(schedule);
        }
        return merged;
    }

    private static Map<String, Set<IUnstructuredItemSchedule>> createGroupedItemSchedules(Set<IUnstructuredItemSchedule> schedules) {
        HashMap groupedSchedules = Maps.newHashMapWithExpectedSize((int)schedules.size());
        for (IUnstructuredItemSchedule schedule : schedules) {
            String id = schedule.getId();
            RmUtils.addToKeyedSets(groupedSchedules, id, schedule);
        }
        return groupedSchedules;
    }

    private static void mergeWaitingFunctions(Map<IResourceType, IBoundedDiscreteStepFunction> newFunctions, Map<IResourceGroup, Map<IResourceType, IBoundedDiscreteStepFunction>> restrictedMap, Set<IResourcePool> resourcePools) {
        for (IResourcePool pool : resourcePools) {
            if (restrictedMap.containsKey(pool.getResourceGroup())) {
                Map<IResourceType, IBoundedDiscreteStepFunction> restricted = restrictedMap.get(pool.getResourceGroup());
                EligibleWorkTimeLineCalculator.mergeFunctionMaps(restricted, newFunctions);
                restrictedMap.put(pool.getResourceGroup(), restricted);
                continue;
            }
            restrictedMap.put(pool.getResourceGroup(), newFunctions);
        }
    }

    private static void mergeFunctionMaps(Map<IResourceType, IBoundedDiscreteStepFunction> functions, Map<IResourceType, IBoundedDiscreteStepFunction> tobeMerged) {
        for (Map.Entry<IResourceType, IBoundedDiscreteStepFunction> functionEntry : functions.entrySet()) {
            IResourceType type = functionEntry.getKey();
            if (tobeMerged.containsKey(type)) {
                IBoundedDiscreteStepFunction newFunction = BoundDiscreteStepFunction.merge(functionEntry.getValue(), tobeMerged.get(type));
                functions.put(type, newFunction);
                continue;
            }
            functions.put(type, functionEntry.getValue());
        }
        for (Map.Entry<IResourceType, IBoundedDiscreteStepFunction> functionEntry : tobeMerged.entrySet()) {
            if (functions.containsKey(functionEntry.getKey())) continue;
            functions.put(functionEntry.getKey(), functionEntry.getValue());
        }
    }
}

