/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.function.IMutableDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.util.function.StepFunctionTroveListImpl;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MutableResource
implements IMutableResource {
    private final IWorkResource wrapped;
    private final IMutableDiscreteStepFunction assignmentFunction;

    MutableResource(IWorkResource wrapped, IMutableDiscreteStepFunction assignmentFunction) {
        this.wrapped = wrapped;
        this.assignmentFunction = assignmentFunction;
    }

    @Override
    public void assignWork(int slotIndex, float amount) {
        this.assignmentFunction.addAt(slotIndex, amount);
    }

    @Override
    public void unassignWork(int slotIndex, float amount) {
        this.assignmentFunction.addAt(slotIndex, -amount);
    }

    @Override
    public String getId() {
        return this.wrapped.getId();
    }

    @Override
    public String getGroupId() {
        return this.wrapped.getGroupId();
    }

    @Override
    public ImmutableNonEmptyPositivePrimitivesMap<IResourceType> getTypeSupplies() {
        return this.wrapped.getTypeSupplies();
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return this.wrapped.getResourceTypes();
    }

    @Override
    public float getUnassignedWorkInWorkSlot(int slotIndex) {
        float unassignedWork = this.wrapped.getUnassignedWorkInWorkSlot(slotIndex) - this.assignmentFunction.getAt(slotIndex);
        if (unassignedWork < 0.01f) {
            return 0.0f;
        }
        return unassignedWork;
    }

    @Override
    public float getRestrictedAvailability(int slotIndex) {
        float unassignedWork = this.wrapped.getRestrictedAvailability(slotIndex) - this.assignmentFunction.getAt(slotIndex);
        if (unassignedWork < 0.01f) {
            return 0.0f;
        }
        return unassignedWork;
    }

    @Override
    public float getAssignedWorkInWorkSlot(int slotIndex) {
        return this.assignmentFunction.getAt(slotIndex);
    }

    @Override
    public boolean isUnlimitedAvailable() {
        return this.wrapped.isUnlimitedAvailable();
    }

    @Override
    public boolean isAvailableInWorkSlot(int slotIndex) {
        return this.wrapped.isAvailableInWorkSlot(slotIndex);
    }

    @Override
    public boolean hasUnassignedWorkInWorkSlot(int slotIndex) {
        return this.getUnassignedWorkInWorkSlot(slotIndex) >= 0.01f;
    }

    @Override
    public int getFirstRegularTimeStep() {
        return this.wrapped.getFirstRegularTimeStep();
    }

    @Override
    public String getSortKey() {
        return this.wrapped.getSortKey();
    }

    @Override
    public boolean isPositiveEnding() {
        return this.wrapped.isPositiveEnding();
    }

    public String toString() {
        return "MutableResource [id = " + this.getId() + "]";
    }

    public static MutableResource createInstance(IWorkResource resourceDefinition) {
        Preconditions.checkNotNull((Object)resourceDefinition, (Object)"wrapped work resource definition must not be null");
        return new MutableResource(resourceDefinition, new StepFunctionTroveListImpl(0.0f));
    }
}

