/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IResourceToTypeWeightVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp.IUnstructuredStageLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PrimitivesMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.uncommons.maths.combinatorics.CombinationGenerator;

@Immutable
public class BalancedStageLpProblem
implements IUnstructuredStageLpProblem {
    private final IUnstructuredStageLpProblem wrapped;
    private final Map<List<IResourceType>, int[]> balanceVarIndices;

    BalancedStageLpProblem(IUnstructuredStageLpProblem wrapped, Map<List<IResourceType>, int[]> balanceVarIndices) {
        this.wrapped = wrapped;
        this.balanceVarIndices = balanceVarIndices;
    }

    @Override
    public PrimitivesMap<IMutableResource> getResourceCost() {
        return this.wrapped.getResourceCost();
    }

    @Override
    public IResourceToTypeWeightVariable getAssignmentVariable(int i) {
        return this.wrapped.getAssignmentVariable(i);
    }

    @Override
    public List<IResourceToTypeWeightVariable> getAssignmentVariables() {
        return this.wrapped.getAssignmentVariables();
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getResourceTypeLimits() {
        return this.wrapped.getResourceTypeLimits();
    }

    @Override
    public PositivePrimitivesMap<IMutableResource> getWorkResourceLimits() {
        return this.wrapped.getWorkResourceLimits();
    }

    @Override
    public Set<Integer> getIndicesForWorkResource(IMutableResource workResource) {
        return this.wrapped.getIndicesForWorkResource(workResource);
    }

    @Override
    public Set<Integer> getIndicesForResourceType(IResourceType resourceType) {
        return this.wrapped.getIndicesForResourceType(resourceType);
    }

    @Override
    public int getVariableCount() {
        return this.wrapped.getVariableCount() + 3 * this.balanceVarIndices.size();
    }

    @Override
    public Map<IResourceType, Set<Integer>> getResourceTypeIndices() {
        return this.wrapped.getResourceTypeIndices();
    }

    @Override
    public Map<IMutableResource, Set<Integer>> getWorkResourceIndices() {
        return this.wrapped.getWorkResourceIndices();
    }

    @Override
    public String getId() {
        return this.wrapped.getId();
    }

    @Override
    public float getMinWorkLoad() {
        return this.wrapped.getMinWorkLoad();
    }

    @Override
    public float getMaxWorkLoad() {
        return this.wrapped.getMaxWorkLoad();
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return this.wrapped.getResourceTypes();
    }

    public Map<List<IResourceType>, int[]> getBalanceVarMap() {
        return this.balanceVarIndices;
    }

    public int getAssignmentVariableCount() {
        return this.wrapped.getVariableCount();
    }

    @Override
    public IEpisode getProjectEpisode() {
        return this.wrapped.getProjectEpisode();
    }

    public static BalancedStageLpProblem createInstance(IUnstructuredStageLpProblem lpProblem) {
        Map<List<IResourceType>, int[]> balanceVarIndices = BalancedStageLpProblem.createMap(lpProblem);
        BalancedStageLpProblem instance = new BalancedStageLpProblem(lpProblem, balanceVarIndices);
        return instance;
    }

    private static Map<List<IResourceType>, int[]> createMap(IUnstructuredStageLpProblem lpProblem) {
        HashMap map = Maps.newHashMap();
        List<IResourceType> skills = RmSortableUtils.sort(lpProblem.getResourceTypes());
        if (skills.size() < 2) {
            return map;
        }
        CombinationGenerator<IResourceType> generator = new CombinationGenerator<IResourceType>(skills, 2);
        int varCount = lpProblem.getVariableCount();
        for (List<IResourceType> list : generator) {
            int[] varIndices = new int[]{varCount++, varCount++, varCount++};
            map.put(list, varIndices);
        }
        return map;
    }
}

