/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositiveTroveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ResourceGroupFactory {
    private static final Log LOGGER = Log.with(ResourceGroupFactory.class);

    private ResourceGroupFactory() {
    }

    public static ResourceGroup createResourceGroup(String id, Set<IWorkResource> workResources, WorkSlotsDefinition workSlotDefinition, String title, String sortKey, boolean strictStageDivision) {
        Preconditions.checkNotNull((Object)id, (Object)"id must not be null");
        Preconditions.checkNotNull(workResources, (Object)"set of multi resources must not be null");
        Preconditions.checkNotNull((Object)workSlotDefinition, (Object)"work slot definition must not be null");
        Preconditions.checkArgument((!workResources.isEmpty() ? 1 : 0) != 0, (Object)"no resources defined");
        LogUtil.debug(LOGGER, "create resource group with id %s", id);
        ImmutableNonEmptyPositivePrimitivesMap<IResourceType> aggregatedSupply = ResourceGroupFactory.getAggregatedSupplyMap(workResources);
        Map<IResourceType, Set<IWorkResource>> typeToResourcesMap = ResourceGroupFactory.getTypeToResourcesSupplyMap(workResources);
        ResourceGroup group = new ResourceGroup(id, workResources, aggregatedSupply, workSlotDefinition, typeToResourcesMap, title, sortKey, strictStageDivision);
        LogUtil.debug(LOGGER, "created resource group: %s", group);
        return group;
    }

    private static Map<IResourceType, Set<IWorkResource>> getTypeToResourcesSupplyMap(Set<IWorkResource> workResources) {
        LogUtil.debugCollection(LOGGER, "create type to resource map for resources: %s", workResources);
        HashMap typeToResourceMap = Maps.newHashMap();
        for (IWorkResource workResource : workResources) {
            Set<IResourceType> availableTypes = workResource.getResourceTypes();
            for (IResourceType availableType : availableTypes) {
                if (typeToResourceMap.containsKey(availableType)) {
                    ((Set)typeToResourceMap.get(availableType)).add(workResource);
                    continue;
                }
                typeToResourceMap.put(availableType, Sets.newHashSet((Object[])new IWorkResource[]{workResource}));
            }
        }
        return typeToResourceMap;
    }

    private static ImmutableNonEmptyPositivePrimitivesMap<IResourceType> getAggregatedSupplyMap(Set<IWorkResource> workResources) {
        Preconditions.checkNotNull(workResources, (Object)"resource set must not be null");
        LogUtil.debug(LOGGER, "create work supply map for resources: %s", workResources);
        MutablePositivePrimitivesMap<IResourceType> workSumMap = RmCollectionUtils.newMutablePositiveMap();
        for (IWorkResource workResource : workResources) {
            ImmutableNonEmptyPositivePrimitivesMap<IResourceType> supplyMap = workResource.getTypeSupplies();
            for (IResourceType workType : supplyMap.keySet()) {
                float supply = supplyMap.get(workType);
                if (!workSumMap.containsKey(workType)) {
                    workSumMap.put(workType, supply);
                    continue;
                }
                float sum = workSumMap.get(workType);
                workSumMap.put(workType, sum += supply);
            }
        }
        LogUtil.debug(LOGGER, "create work sum map");
        return (ImmutableNonEmptyPositivePrimitivesMap)ImmutableNonEmptyPositiveTroveMap.tryCreate(workSumMap).get();
    }
}

