/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util.collection;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.ISortable;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.SortedPositivePrimitiveMap;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class SortedPositivePrimitivesWrapper<K>
implements SortedPositivePrimitiveMap<K> {
    private final SortedSet<K> sortedKeys;
    private final PositivePrimitivesMap<K> wrapped;

    SortedPositivePrimitivesWrapper(SortedSet<K> sortedKeys, PositivePrimitivesMap<K> wrapped) {
        this.sortedKeys = sortedKeys;
        this.wrapped = wrapped;
    }

    @Override
    public Set<K> keySet() {
        return this.sortedKeys;
    }

    @Override
    public float get(K key) {
        return this.wrapped.get(key);
    }

    @Override
    public boolean containsKey(K key) {
        return this.wrapped.containsKey(key);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public float getValueSum() {
        return this.wrapped.getValueSum();
    }

    @Override
    public float getMinValue() {
        return this.wrapped.getMinValue();
    }

    @Override
    public float getMaxValue() {
        return this.wrapped.getMaxValue();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    public static <K extends ISortable> SortedPositivePrimitiveMap<K> create(PositivePrimitivesMap<K> unsortedMap) {
        TreeSet sorted = Sets.newTreeSet((Comparator)new Comparator<ISortable>(){

            @Override
            public int compare(ISortable o1, ISortable o2) {
                return o1.getSortKey().compareTo(o2.getSortKey());
            }
        });
        sorted.addAll(unsortedMap.keySet());
        return new SortedPositivePrimitivesWrapper<K>(sorted, unsortedMap);
    }
}

