/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.rand.settings;

import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.data.generator.rand.settings.IRandomizedSettingsConfiguration;

public class RandomizedSettingsConfiguration
implements IRandomizedSettingsConfiguration {
    private final int stages;
    private final int minSkills;
    private final int maxSkills;

    public RandomizedSettingsConfiguration(int stages, int minSkills, int maxSkills) {
        this.stages = stages;
        this.minSkills = minSkills;
        this.maxSkills = maxSkills;
    }

    @Override
    public int getStages() {
        return this.stages;
    }

    @Override
    public int getMinSkills() {
        return this.minSkills;
    }

    @Override
    public int getMaxSkills() {
        return this.maxSkills;
    }

    public static class Builder {
        private int stages = 5;
        private int minSkills = 1;
        private int maxSkills = 7;

        public Builder stages(int stages) {
            this.stages = stages;
            return this;
        }

        public Builder withNumberOfSkillBetween(int minSkills, int maxSkills) {
            Preconditions.checkArgument((minSkills <= maxSkills ? 1 : 0) != 0);
            this.minSkills = minSkills;
            this.maxSkills = maxSkills;
            return this;
        }

        public IRandomizedSettingsConfiguration build() {
            return new RandomizedSettingsConfiguration(this.stages, this.minSkills, this.maxSkills);
        }
    }
}

