/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.upgrade.tasks;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlanConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.upgrade.BaseUpgradeTask;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class U_00201_PlanDescriptionUpgradeTask
extends BaseUpgradeTask {
    private static final Log LOGGER = Log.with(U_00201_PlanDescriptionUpgradeTask.class);

    @Override
    protected int getDataModelVersion() {
        return 201;
    }

    @Override
    protected void performUpgrade(ActiveObjectsUtilities utils, PersistenceIndex persistenceIndex) throws Exception {
        UpgradeSQL upgradeSQL = new UpgradeSQL(utils);
        for (String planId : upgradeSQL.getPlansWithoutConfigurations(this, utils)) {
            AOPlanConfiguration planConfiguration = (AOPlanConfiguration)utils.create(AOPlanConfiguration.class);
            planConfiguration.setAOPlan((AOPlan)utils.get(AOPlan.class, planId));
            planConfiguration.save();
            LOGGER.info("Created plan configuration with for plan '%s", planId);
        }
    }

    @Override
    protected boolean migrateOnUpgrade() {
        return true;
    }

    private static class UpgradeSQL
    extends BaseAOPersistenceSQL {
        public UpgradeSQL(ActiveObjectsUtilities utils) {
            super(utils);
        }

        public List<String> getPlansWithoutConfigurations(BaseUpgradeTask task, ActiveObjectsUtilities utils) throws SQLException {
            return this.sql(new IQuery<List<String>>(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOPlan.class, "p").withTable(AOPlanConfiguration.class, "c").select().colId("p").from("p").where().colId("p").raw("NOT IN (").select().col("c", "aoplan").from("c").raw(")");
                }

                @Override
                public List<String> handleResult(ResultSet result) throws Exception {
                    ArrayList retVal = Lists.newArrayList();
                    while (result.next()) {
                        retVal.add(BaseAOPersistenceSQL.getString(result, 1));
                    }
                    return retVal;
                }
            }, task.getOrCreateConnection(utils.getAccessor()));
        }
    }
}

