/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.api.PluginPermission;
import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.BadDeveloperException;
import com.radiantminds.roadmap.common.handlers.ClientIdCache;
import com.radiantminds.roadmap.common.handlers.DatabaseContext;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.EntityContextPreparationResult;
import com.radiantminds.roadmap.common.handlers.NotAuthorizedException;
import com.radiantminds.roadmap.common.handlers.SecurityAnnotations;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanFullUserAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.permissions.PlanPermission;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;

class SecureEntityContextInitializer {
    private final PortfolioPlanPersistence planPersistence;
    private final PluginPermissions pluginPermissionHandler;
    private final PlanPermissions planPermissionHandler;
    private final SecurityAnnotations securityConfig;

    SecureEntityContextInitializer(PortfolioPlanPersistence planPersistence, PluginPermissions pluginPermissionHandler, PlanPermissions planPermissionHandler, SecurityAnnotations securityConfig) {
        this.planPersistence = planPersistence;
        this.pluginPermissionHandler = pluginPermissionHandler;
        this.planPermissionHandler = planPermissionHandler;
        this.securityConfig = securityConfig;
    }

    public <U extends IIdentifiable> void initialize(EntityContext<U> uEntityContext, IEntityPersistence<U> uiEntityPersistence, Optional<DatabaseContext> dbContext, ClientIdCache clientIdCache) throws Exception {
        SecureEntityContextInitializer.initialize(uEntityContext, uiEntityPersistence, dbContext, this.planPersistence, this.pluginPermissionHandler, this.planPermissionHandler, this.securityConfig, clientIdCache);
    }

    static <U extends IIdentifiable> void initialize(EntityContext<U> entityContext, IEntityPersistence<U> entityPersistence, Optional<DatabaseContext> dbContext, PortfolioPlanPersistence planPersistence, PluginPermissions pluginPermissionHandler, PlanPermissions planPermissionHandler, SecurityAnnotations securityConfig, ClientIdCache clientIdCache) throws Exception {
        if (securityConfig.getPlanFullUserAccess().isPresent()) {
            EntityContextPreparationResult preparationResult = entityContext.prepare(entityPersistence, planPersistence, dbContext, clientIdCache, planPermissionHandler, PlanPermission.Editor);
            if (preparationResult.getPlanPermissionCheckResult().needsPluginPermission() && !pluginPermissionHandler.check(PluginPermission.FullEditor)) {
                throw new NotAuthorizedException();
            }
            entityContext.init(preparationResult, VersionIncrementMode.isIncrement(((AuthorizedPlanFullUserAccess)securityConfig.getPlanFullUserAccess().get()).incrementEntityVersion()), VersionIncrementMode.isIncrement(((AuthorizedPlanFullUserAccess)securityConfig.getPlanFullUserAccess().get()).incrementPlanVersion()), VersionIncrementMode.isIncrement(((AuthorizedPlanFullUserAccess)securityConfig.getPlanFullUserAccess().get()).incrementSchedulingVersion()), ((AuthorizedPlanFullUserAccess)securityConfig.getPlanFullUserAccess().get()).incrementSchedulingVersion() == VersionIncrementMode.Dynamic, ((AuthorizedPlanFullUserAccess)securityConfig.getPlanFullUserAccess().get()).entityNeeded());
        } else if (securityConfig.getPlanUserAccess().isPresent()) {
            EntityContextPreparationResult preparationResult = entityContext.prepare(entityPersistence, planPersistence, dbContext, clientIdCache, planPermissionHandler, PlanPermission.Editor);
            if (preparationResult.getPlanPermissionCheckResult().needsPluginPermission() && !pluginPermissionHandler.checkOr(PluginPermission.FullEditor, PluginPermission.NonPublishingEditor)) {
                throw new NotAuthorizedException();
            }
            entityContext.init(preparationResult, VersionIncrementMode.isIncrement(((AuthorizedPlanUserAccess)securityConfig.getPlanUserAccess().get()).incrementEntityVersion()), VersionIncrementMode.isIncrement(((AuthorizedPlanUserAccess)securityConfig.getPlanUserAccess().get()).incrementPlanVersion()), VersionIncrementMode.isIncrement(((AuthorizedPlanUserAccess)securityConfig.getPlanUserAccess().get()).incrementSchedulingVersion()), ((AuthorizedPlanUserAccess)securityConfig.getPlanUserAccess().get()).incrementSchedulingVersion() == VersionIncrementMode.Dynamic, ((AuthorizedPlanUserAccess)securityConfig.getPlanUserAccess().get()).entityNeeded());
        } else if (securityConfig.getPlanReadAccess().isPresent()) {
            EntityContextPreparationResult preparationResult = entityContext.prepare(entityPersistence, planPersistence, dbContext, clientIdCache, planPermissionHandler, PlanPermission.Editor, PlanPermission.Viewer);
            if (preparationResult.getPlanPermissionCheckResult().needsPluginPermission() && !pluginPermissionHandler.checkOr(PluginPermission.FullEditor, PluginPermission.NonPublishingEditor, PluginPermission.Viewer)) {
                throw new NotAuthorizedException();
            }
            entityContext.init(preparationResult, false, false, false, false, ((AuthorizedPlanReadAccess)securityConfig.getPlanReadAccess().get()).entityNeeded());
        } else {
            throw new BadDeveloperException("Dear developer; thou shall not use entity context without a plan access annotation.");
        }
    }
}

