/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestStageOrSkillId;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IResourceTypeDescription;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ISprintData;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="sprint")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestSprintSolution {
    @XmlElement
    String team;
    @XmlElement
    Integer index;
    @XmlElement
    String id;
    @XmlElement
    Long start;
    @XmlElement
    Long end;
    @XmlElement
    Double utilization;
    @XmlElement
    Double plannedWorkload;
    @XmlElement
    Double averageWorkload;
    @XmlElement
    Double availableWorkload;
    @XmlElement
    List<RestStageOrSkillId> freeCapacities;
    @XmlElement
    List<RestStageOrSkillId> bottlenecks;
    private static Function<IResourceTypeDescription, RestStageOrSkillId> TYPE_TRAFO = new Function<IResourceTypeDescription, RestStageOrSkillId>(){

        public RestStageOrSkillId apply(@Nullable IResourceTypeDescription toTransform) {
            if (toTransform == null) {
                return null;
            }
            return RestStageOrSkillId.create(toTransform);
        }
    };

    private RestSprintSolution() {
    }

    public static RestSprintSolution create(ISprintData sprintData) {
        RestSprintSolution instance = new RestSprintSolution();
        instance.team = sprintData.getTeamId();
        instance.id = (String)sprintData.getSprintId().orNull();
        instance.index = sprintData.getIndex();
        instance.utilization = sprintData.getUtilization();
        instance.plannedWorkload = sprintData.getWorkLoad();
        instance.averageWorkload = sprintData.getAvgResourceUtilization();
        instance.availableWorkload = sprintData.getAvailableWork();
        instance.freeCapacities = Lists.transform(sprintData.getFreeCapacitiesOfResourceTypes(), TYPE_TRAFO);
        instance.bottlenecks = Lists.transform(sprintData.getPriorizedBottleneckResourceTypes(), TYPE_TRAFO);
        instance.start = sprintData.getStartTimeStamp();
        instance.end = sprintData.getEndTimeStamp();
        return instance;
    }
}

