/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling.annotations;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.MissingWorkTypePerTeamViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.MissingWorkTypeViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.PlanningHorizonReachedWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.UnstructuredItemNotFullyScheduledWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.WarningType;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.rest.entities.scheduling.annotations.RestMissingTeamWorktypeAnnotation;
import com.radiantminds.roadmap.common.rest.entities.scheduling.annotations.RestMissingWorkTypesAnnotation;
import com.radiantminds.roadmap.common.rest.entities.scheduling.annotations.RestNotFullyScheduledAnnotation;
import com.radiantminds.roadmap.common.rest.entities.scheduling.annotations.RestPlanningHorizonAnnotation;
import com.radiantminds.roadmap.common.rest.entities.scheduling.annotations.RestSchedulingAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class RestSchedulingSolutionAnnotationFactory {
    public static List<RestSchedulingAnnotation> createAnnotations(SchedulingPlan plan, Set<IScheduleViolation> violations, Set<IScheduleWarning> warnings) {
        RestSchedulingAnnotation annotation;
        ArrayList retVal = Lists.newArrayList();
        for (IScheduleViolation violation : violations) {
            switch (violation.getViolationType()) {
                case MissingTeamSkills: {
                    annotation = RestMissingTeamWorktypeAnnotation.create((MissingWorkTypePerTeamViolation)violation);
                    break;
                }
                case MissingWorkType: {
                    annotation = RestMissingWorkTypesAnnotation.create((MissingWorkTypeViolation)violation);
                    break;
                }
                default: {
                    annotation = new RestSchedulingAnnotation(violation.getId(), violation.getViolationType().toString());
                }
            }
            retVal.add(annotation);
        }
        for (IScheduleWarning warning : warnings) {
            switch (warning.getWarningType()) {
                case NotFullyScheduled: {
                    annotation = new RestNotFullyScheduledAnnotation(warning.getId(), warning.getWarningType().toString(), Double.valueOf(((UnstructuredItemNotFullyScheduledWarning)warning).getUnscheduledWorkAmount()));
                    break;
                }
                case PlanningHorizonReached: {
                    annotation = RestPlanningHorizonAnnotation.create((PlanningHorizonReachedWarning)warning);
                    break;
                }
                default: {
                    annotation = new RestSchedulingAnnotation(warning.getId(), warning.getWarningType().toString());
                }
            }
            if (warning.getWarningType() == WarningType.WorkSlotExceeded && (warning.getWarningType() != WarningType.WorkSlotExceeded || !plan.getPlanConfiguration().getSprintExceededWarn().booleanValue())) continue;
            retVal.add(annotation);
        }
        return retVal;
    }
}

