/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.stages;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.skills.RestStage;
import com.radiantminds.roadmap.common.rest.services.stages.PlanStageServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/plans/{id}/stages")
@Component
public class PlanStageService {
    private final PlanStageServiceHandler handler;

    @Autowired
    public PlanStageService(SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioStagePersistence stagePersistence) {
        this.handler = handlerFactory.createProxy(PlanStageServiceHandler.class, new PlanStageServiceHandler.Impl(activeObjectsUtilities, stagePersistence, workItemPersistence), planPersistence);
    }

    @GET
    public Response getAllStages(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion) throws Exception {
        return this.handler.getAllStages(EntityContext.from(planId, expectedPlanVersion));
    }

    @POST
    public Response addStageToPlan(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestStage newStage) throws Exception {
        return this.handler.addStageToPlan(EntityContext.from(planId, expectedPlanVersion, clientId), newStage);
    }

    @PUT
    @Path(value="/rank")
    public Response rankStage(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestRank rank) throws Exception {
        return this.handler.rankStage(EntityContext.from(planId, expectedPlanVersion, clientId), rank);
    }
}

