/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.teams;

import com.google.common.collect.Iterables;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.people.PlanningMode;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.generator.template.PlanTemplate;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtils;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtilsCallback;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.people.RestTeam;
import java.util.List;
import javax.ws.rs.core.Response;

public interface PlanTeamServiceHandler {
    @AuthorizedPlanReadAccess
    public Response getAllTeams(EntityContext<IPlan> var1) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.Off)
    public Response addTeamToPlan(EntityContext<IPlan> var1, RestTeam var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.Off)
    public Response rankTeam(EntityContext<IPlan> var1, RestRank var2) throws Exception;

    public static class Impl
    implements PlanTeamServiceHandler {
        private final PortfolioTeamPersistence teamPersistence;
        private final SubCollectionUtils subCollectionUtils;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, PortfolioTeamPersistence teamPersistence, PortfolioWorkItemPersistence workItemPersistence) {
            this.teamPersistence = teamPersistence;
            this.subCollectionUtils = new SubCollectionUtils(activeObjectsUtilities, workItemPersistence);
        }

        @Override
        public Response getAllTeams(EntityContext<IPlan> entityContext) throws Exception {
            List<ITeam> teams = this.teamPersistence.listCustom(entityContext.getEntityId());
            return entityContext.okForList(Iterables.toArray(ToRest.transferList(RestTeam.class, ITeam.class, teams), RestTeam.class));
        }

        @Override
        public Response addTeamToPlan(final EntityContext<IPlan> entityContext, final RestTeam newTeam) throws Exception {
            return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AOTeam.class, "plan", newTeam, new SubCollectionUtilsCallback.Adapter<IPlan, ITeam, RestTeam>(){

                @Override
                public Response preOperationChecks() throws Exception {
                    if (PlanningUnit.STORY_POINTS.unit().equals(((IPlan)entityContext.getEntity()).getPlanConfiguration().getPlanningUnit()) && PlanningMode.Kanban.equals((Object)newTeam.getPlanningMode())) {
                        return ResponseBuilder.badRequest(RestMessaging.warning("kanban-not-allowed"));
                    }
                    return null;
                }

                @Override
                public void setParent(IPlan parent, ITeam entity) {
                    if (entity.getPlanningMode() == null && PlanTemplate.KANBAN.toString().equals(parent.getPlanConfiguration().getTemplateType())) {
                        entity.setPlanningMode(PlanningMode.Kanban);
                    }
                    entity.setPlan(parent);
                }

                @Override
                public ITeam persist(ITeam entity) throws PersistenceException {
                    return teamPersistence.persist(entity);
                }

                @Override
                public ITeam get(String id) throws Exception {
                    return (ITeam)teamPersistence.get(id);
                }
            });
        }

        @Override
        public Response rankTeam(EntityContext<IPlan> entityContext, RestRank rank) throws Exception {
            return this.subCollectionUtils.rankEntity(entityContext, AOTeam.class, this.teamPersistence, "plan", rank);
        }
    }
}

