/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class TransformationUtils {
    private static final Log LOGGER = Log.with(TransformationUtils.class);

    private TransformationUtils() {
    }

    public static Map<SchedulingWorkItem, Set<SchedulingWorkItem>> calculateTransitivePrerequisites(Set<? extends SchedulingWorkItem> consideredItems, Collection<? extends SchedulingWorkItem> allWorkItems) {
        BiMap<String, ? extends SchedulingWorkItem> allWorkItemDictionary = RmIdentifiableUtils.createIdMap(allWorkItems);
        HashMap transitivePrerequisites = Maps.newHashMap();
        for (SchedulingWorkItem schedulingWorkItem : consideredItems) {
            HashSet done = Sets.newHashSet();
            Set<SchedulingWorkItem> prerequisites = TransformationUtils.getTransitivePrerequisites(schedulingWorkItem, done, allWorkItemDictionary, true);
            transitivePrerequisites.put(schedulingWorkItem, prerequisites);
        }
        return transitivePrerequisites;
    }

    private static Set<SchedulingWorkItem> getTransitivePrerequisites(SchedulingWorkItem todo, Set<SchedulingWorkItem> done, BiMap<String, ? extends SchedulingWorkItem> itemDictionary, boolean first) {
        if (!first) {
            done.add(todo);
        }
        Set<SchedulingWorkItem> directPrerequisites = TransformationUtils.getDirectPrerequisites(todo, itemDictionary);
        directPrerequisites.addAll(TransformationUtils.getDirectPrerequisites((SchedulingWorkItem)itemDictionary.get((Object)todo.getParentId()), itemDictionary));
        for (SchedulingWorkItem nextItem : directPrerequisites) {
            if (done.contains(nextItem)) continue;
            Set<SchedulingWorkItem> nextDone = TransformationUtils.getTransitivePrerequisites(nextItem, done, itemDictionary, false);
            done.addAll(nextDone);
        }
        return done;
    }

    private static Set<SchedulingWorkItem> getDirectPrerequisites(SchedulingWorkItem todo, BiMap<String, ? extends SchedulingWorkItem> itemDictionary) {
        HashSet directPrerequisites = Sets.newHashSet();
        if (todo == null) {
            return directPrerequisites;
        }
        Set<SchedulingWorkItem> checkedPrerequisites = TransformationUtils.getNullSafePrerequisitesFromIds(todo.getPrerequisites(), itemDictionary);
        directPrerequisites.addAll(checkedPrerequisites);
        for (SchedulingWorkItem checkedItem : checkedPrerequisites) {
            Set<String> checkedChildrenIds = checkedItem.getChildIds();
            if (checkedChildrenIds == null) continue;
            directPrerequisites.addAll(RmIdentifiableUtils.getElementsWithIds(checkedChildrenIds, itemDictionary.values()));
        }
        return directPrerequisites;
    }

    private static Set<SchedulingWorkItem> getNullSafePrerequisitesFromIds(Collection<String> prerequisites, BiMap<String, ? extends SchedulingWorkItem> itemDictionary) {
        HashSet checked = Sets.newHashSet();
        if (prerequisites == null) {
            return checked;
        }
        for (String prerequisiteId : prerequisites) {
            SchedulingWorkItem prerequisite = (SchedulingWorkItem)itemDictionary.get((Object)prerequisiteId);
            if (prerequisite != null) {
                checked.add(prerequisite);
                continue;
            }
            LOGGER.debug("ignored prequisite with id: %s", prerequisiteId);
        }
        return checked;
    }
}

