/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.utils.estimate;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.plans.FullContentSchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimationEnrichedWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemExtensionLinkData;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.common.extensions.workitems.StatusData;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.rest.entities.progress.RestProgressConfiguration;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimate;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.WorkItemConstraintChecker;
import com.radiantminds.roadmap.common.utils.estimate.EstimateReplanningSuggestion;
import com.radiantminds.roadmap.common.utils.estimate.EstimateSuggestionTools;
import com.radiantminds.roadmap.common.utils.estimate.EstimateSuggestionUtil;
import com.radiantminds.roadmap.common.utils.estimate.SuggestionMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EstimateReplanningUtil {
    private static final Log LOGGER = Log.with(EstimateSuggestionUtil.class);
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final PortfolioEstimatePersistence estimatePersistence;
    private final WorkItemExtension workItemExtension;

    public EstimateReplanningUtil(PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, WorkItemExtension workItemExtension) {
        this.workItemPersistence = workItemPersistence;
        this.estimatePersistence = estimatePersistence;
        this.workItemExtension = workItemExtension;
    }

    public void applySuggestions(FullContentSchedulingPlan plan, SuggestionMode suggestionMode) throws Exception {
        Set<IWorkItem> assignableWorkItems = EstimateReplanningUtil.getAssignableWorkItems(plan);
        Map<String, Set<String>> itemIdToLinks = EstimateReplanningUtil.getItemIdToExtensionLinks(assignableWorkItems);
        Set<String> linkIds = RmUtils.mergeToSet(itemIdToLinks.values());
        RestProgressConfiguration progressConfiguration = RestProgressConfiguration.from(plan.getPlanConfiguration());
        WorkItemExtensionLinkData extensionLinkData = this.workItemExtension.getExtensionLinkData(progressConfiguration, linkIds).getResult();
        Map<String, ProgressData> progressMap = EstimateReplanningUtil.getLinkProgresses(extensionLinkData, linkIds);
        Map<String, StatusData> statusMap = EstimateReplanningUtil.getLinkStatuses(extensionLinkData, linkIds);
        Map<String, EstimateReplanningSuggestion> suggestions = EstimateReplanningUtil.computeSuggestions(plan, progressMap, statusMap, suggestionMode);
        this.storeSuggestions(suggestions);
    }

    private static Map<String, Set<String>> getItemIdToExtensionLinks(Set<IWorkItem> workItems) {
        HashMap itemToLinks = Maps.newHashMap();
        for (IWorkItem workItem : workItems) {
            for (IExtensionLink extensionLink : workItem.getExtensionLinks()) {
                RmUtils.addToKeyedSets(itemToLinks, workItem.getId(), extensionLink.getExtensionLink());
            }
        }
        return itemToLinks;
    }

    private static Set<IWorkItem> getAssignableWorkItems(IPlan plan) {
        HashSet assignable = Sets.newHashSet();
        for (IWorkItem workItem : plan.getWorkItems()) {
            try {
                if (!WorkItemConstraintChecker.isAssignable(workItem)) continue;
                assignable.add(workItem);
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("Unable to compute suggestions for workitem '%s'.", workItem.getId()), new Object[0]);
                LOGGER.exception(ex, Log.LogLevel.WARN);
            }
        }
        return assignable;
    }

    private static Map<String, ProgressData> getLinkProgresses(WorkItemExtensionLinkData extensionLinkData, Set<String> linkIds) {
        HashMap map = Maps.newHashMap();
        for (String link : linkIds) {
            ProgressData fullProgress = extensionLinkData.getFullProgress(link);
            map.put(link, fullProgress);
        }
        return map;
    }

    private static Map<String, StatusData> getLinkStatuses(WorkItemExtensionLinkData extensionLinkData, Set<String> linkIds) {
        HashMap map = Maps.newHashMap();
        for (String link : linkIds) {
            StatusData statusData = extensionLinkData.getStatusData(link);
            map.put(link, statusData);
        }
        return map;
    }

    private void storeSuggestions(Map<String, EstimateReplanningSuggestion> suggestions) throws Exception {
        for (String workItemId : suggestions.keySet()) {
            EstimateReplanningSuggestion suggestion = suggestions.get(workItemId);
            if (suggestion.getTotalEstimate() != null) {
                this.estimatePersistence.setTotalEstimate(workItemId, new RestEstimate(suggestion.getTotalEstimate()), DataMode.Replanning);
            }
            for (String stageId : suggestion.getStageEstimates().keySet()) {
                this.estimatePersistence.setStageEstimate(workItemId, stageId, suggestion.getStageEstimates().get(stageId), DataMode.Replanning);
            }
            for (String skillId : suggestion.getSkillEstimates().keySet()) {
                this.estimatePersistence.setSkillEstimate(workItemId, skillId, suggestion.getSkillEstimates().get(skillId), DataMode.Replanning);
            }
            if (suggestion.getStatus() == null) continue;
            this.workItemPersistence.setReplanningStatus(workItemId, suggestion.getStatus());
        }
    }

    private static Map<String, EstimateReplanningSuggestion> computeSuggestions(FullContentSchedulingPlan plan, Map<String, ProgressData> progressMap, Map<String, StatusData> statusMap, SuggestionMode suggestionMode) {
        Map<String, Double> stagePercentages = EstimateSuggestionTools.computeStagePercentages(plan);
        HashMap suggestions = Maps.newHashMap();
        for (IEstimationEnrichedWorkItem workItem : plan.getEstimationEnrichedWorkItems()) {
            EstimateReplanningSuggestion suggestion = EstimateSuggestionUtil.computeEstimateSuggestions(plan, workItem, progressMap, statusMap, stagePercentages, suggestionMode);
            if (suggestion == null) continue;
            suggestions.put(workItem.getId(), suggestion);
        }
        return suggestions;
    }
}

