/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.communication;

import com.atlassian.mail.Email;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.radiantminds.roadmap.common.extensions.communication.CommunicationExtension;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraCommunicationExtension
implements CommunicationExtension {
    private final MailServerManager mailServerManager;

    @Autowired
    public JiraCommunicationExtension(MailServerManager mailServerManager) {
        this.mailServerManager = mailServerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMail(String from, String fromName, String to, String subject, String message, List<?> attachments) throws Exception {
        if (!this.mailServerManager.isDefaultSMTPMailServerDefined()) {
            throw new Exception("no-mail-server-defined");
        }
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart mimeMessage = new MimeBodyPart();
        mimeMessage.setText(message);
        multipart.addBodyPart((BodyPart)mimeMessage);
        if (attachments != null) {
            for (Object attachment : attachments) {
                multipart.addBodyPart((BodyPart)((MimeBodyPart)attachment));
            }
        }
        Email email = new Email(to);
        email.setSubject(subject);
        email.setFrom(from);
        email.setFromName(fromName);
        email.setMultipart((Multipart)multipart);
        SMTPMailServer server = this.mailServerManager.getDefaultSMTPMailServer();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Session.class.getClassLoader());
            server.send(email);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

